/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface ISpecialArmor {
    public static boolean hasCompleteArmor(LivingEntity living) {
        EquipmentSlot[] var1 = EquipmentSlot.values();
        int var2 = var1.length;
        for (EquipmentSlot slot : var1) {
            Item item;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack stack = living.getItemBySlot(slot);
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof ISpecialArmor) {
                ISpecialArmor hazmat = (ISpecialArmor)item;
                continue;
            }
            return false;
        }
        return true;
    }

    public static float getDamageAfterAbsorb(float damage, float totalArmor, float toughnessAttribute) {
        float f = 2.0f + toughnessAttribute / 4.0f;
        float f1 = Mth.clamp((float)(totalArmor - damage / f), (float)(totalArmor * 0.2f), (float)20.0f);
        return damage * (1.0f - f1 / 25.0f);
    }

    public static float getDamageAfterMagicAbsorb(float damage, float enchantModifiers) {
        float f = Mth.clamp((float)enchantModifiers, (float)0.0f, (float)20.0f);
        return damage * (1.0f - f / 25.0f);
    }

    public ArmorProperties getProperties(LivingEntity var1, @Nonnull ItemStack var2, DamageSource var3, double var4, int var6);

    public int getArmorDisplay(Player var1, @Nonnull ItemStack var2, int var3);

    public void damageArmor(LivingEntity var1, @Nonnull ItemStack var2, DamageSource var3, float var4, int var5);

    default public boolean handleUnblockableDamage(LivingEntity entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return false;
    }

    public static class ArmorProperties
    implements Comparable<ArmorProperties> {
        private static final boolean DEBUG = false;
        public int Priority = 0;
        public int AbsorbMax = Integer.MAX_VALUE;
        public double AbsorbRatio = 0.0;
        public double Armor = 0.0;
        public double Toughness = 0.0;
        public int Slot = 0;

        public ArmorProperties(int priority, double ratio, int max) {
            this.Priority = priority;
            this.AbsorbRatio = ratio;
            this.Armor = 0.0;
            this.Toughness = 0.0;
            this.AbsorbMax = max;
        }

        public static float applyArmor(LivingEntity entity, NonNullList<ItemStack> inventory, DamageSource source, double damage) {
            double totalArmor = entity.getArmorValue();
            double totalToughness = entity.getAttributeValue(Attributes.ARMOR_TOUGHNESS);
            if (source.is(DamageTypeTags.BYPASSES_ARMOR)) {
                totalArmor = 0.0;
                totalToughness = 0.0;
            }
            ArrayList<ArmorProperties> dmgVals = new ArrayList<ArmorProperties>();
            for (int slot = 0; slot < inventory.size(); ++slot) {
                ItemStack stack = (ItemStack)inventory.get(slot);
                if (stack.isEmpty()) continue;
                ArmorProperties prop = null;
                if (!(stack.getItem() instanceof ISpecialArmor)) continue;
                if (!source.is(DamageTypeTags.BYPASSES_ARMOR) || ((ISpecialArmor)stack.getItem()).handleUnblockableDamage(entity, stack, source, damage, slot)) {
                    ISpecialArmor armor = (ISpecialArmor)stack.getItem();
                    prop = armor.getProperties(entity, stack, source, damage, slot).copy();
                    totalArmor += prop.Armor;
                    totalToughness += prop.Toughness;
                }
                if (prop == null) continue;
                prop.Slot = slot;
                dmgVals.add(prop);
            }
            if (!dmgVals.isEmpty()) {
                ArmorProperties[] props = dmgVals.toArray(new ArmorProperties[0]);
                ArmorProperties.StandardizeList(props, damage);
                int level = props[0].Priority;
                double ratio = 0.0;
                for (ArmorProperties prop : props) {
                    if (level != prop.Priority) {
                        damage -= damage * ratio;
                        ratio = 0.0;
                        level = prop.Priority;
                    }
                    ratio += prop.AbsorbRatio;
                    double absorb = damage * prop.AbsorbRatio;
                    if (!(absorb > 0.0)) continue;
                    ItemStack stack = (ItemStack)inventory.get(prop.Slot);
                    if (stack.getItem() instanceof ISpecialArmor) {
                        ((ISpecialArmor)stack.getItem()).damageArmor(entity, stack, source, (float)absorb, prop.Slot);
                    }
                    if (!stack.isEmpty()) continue;
                    inventory.set(prop.Slot, (Object)ItemStack.EMPTY);
                }
                damage -= damage * ratio;
            }
            if (damage > 0.0 && (totalArmor > 0.0 || totalToughness > 0.0)) {
                double armorDamage = Math.max(1.0, damage / 4.0);
                for (int i = 0; i < inventory.size(); ++i) {
                    if (!(((ItemStack)inventory.get(i)).getItem() instanceof ArmorItem) || !(((ItemStack)inventory.get(i)).getItem() instanceof ISpecialArmor)) continue;
                    ((ItemStack)inventory.get(i)).hurtAndBreak((int)armorDamage, (ServerLevel)entity.level(), entity, ignored -> {});
                    if (((ItemStack)inventory.get(i)).getCount() != 0) continue;
                    inventory.set(i, (Object)ItemStack.EMPTY);
                }
                damage = ISpecialArmor.getDamageAfterAbsorb((float)damage, (float)totalArmor, (float)totalToughness);
            }
            return (float)damage;
        }

        private static void StandardizeList(ArmorProperties[] armor, double damage) {
            Arrays.sort(armor);
            int start = 0;
            double total = 0.0;
            int priority = armor[0].Priority;
            int pStart = 0;
            boolean pChange = false;
            boolean pFinished = false;
            for (int x = 0; x < armor.length; ++x) {
                total += armor[x].AbsorbRatio;
                if (x != armor.length - 1 && armor[x].Priority == priority) continue;
                if (armor[x].Priority != priority) {
                    total -= armor[x].AbsorbRatio;
                    --x;
                    pChange = true;
                }
                if (total > 1.0) {
                    for (y = start; y <= x; ++y) {
                        double newRatio = armor[y].AbsorbRatio / total;
                        if (newRatio * damage > (double)armor[y].AbsorbMax) {
                            armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                            total = 0.0;
                            for (int z = pStart; z <= y; ++z) {
                                total += armor[z].AbsorbRatio;
                            }
                            start = y + 1;
                            x = y;
                            break;
                        }
                        armor[y].AbsorbRatio = newRatio;
                        pFinished = true;
                    }
                    if (!pChange || !pFinished) continue;
                    damage -= damage * total;
                    total = 0.0;
                    start = x + 1;
                    priority = armor[start].Priority;
                    pStart = start;
                    pChange = false;
                    pFinished = false;
                    if (!(damage <= 0.0)) continue;
                    for (y = x + 1; y < armor.length; ++y) {
                        armor[y].AbsorbRatio = 0.0;
                    }
                } else {
                    for (y = start; y <= x; ++y) {
                        total -= armor[y].AbsorbRatio;
                        if (damage * armor[y].AbsorbRatio > (double)armor[y].AbsorbMax) {
                            armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                        }
                        total += armor[y].AbsorbRatio;
                    }
                    damage -= damage * total;
                    total = 0.0;
                    if (x == armor.length - 1) continue;
                    start = x + 1;
                    priority = armor[start].Priority;
                    pStart = start;
                    pChange = false;
                    if (!(damage <= 0.0)) continue;
                    for (y = x + 1; y < armor.length; ++y) {
                        armor[y].AbsorbRatio = 0.0;
                    }
                }
                break;
            }
        }

        @Override
        public int compareTo(ArmorProperties o) {
            if (o.Priority != this.Priority) {
                return o.Priority - this.Priority;
            }
            double left = this.AbsorbRatio == 0.0 ? 0.0 : (double)this.AbsorbMax * 100.0 / this.AbsorbRatio;
            double right = o.AbsorbRatio == 0.0 ? 0.0 : (double)o.AbsorbMax * 100.0 / o.AbsorbRatio;
            return (int)(left - right);
        }

        public String toString() {
            return String.format("%d, %d, %f, %d", this.Priority, this.AbsorbMax, this.AbsorbRatio, this.AbsorbRatio == 0.0 ? 0 : (int)((double)this.AbsorbMax * 100.0 / this.AbsorbRatio));
        }

        public ArmorProperties copy() {
            ArmorProperties copy = new ArmorProperties(this.Priority, this.AbsorbRatio, this.AbsorbMax);
            copy.Armor = this.Armor;
            copy.Toughness = this.Toughness;
            return copy;
        }
    }
}

