/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.HeatComponent;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.Localization;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemsHeatSensor
extends Item
implements IItemTab {
    private String nameItem;

    public ItemsHeatSensor() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.heat_sensor.info")));
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.heat_sensor";
        }
        return this.nameItem;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext p_41427_) {
        BlockEntity tileEntity;
        Player player = p_41427_.getPlayer();
        Level world = p_41427_.getLevel();
        BlockPos pos = p_41427_.getClickedPos();
        if (!world.isClientSide && (tileEntity = world.getBlockEntity(pos)) instanceof BlockEntityInventory) {
            BlockEntityInventory tileEntityInventory = (BlockEntityInventory)tileEntity;
            HeatComponent component = tileEntityInventory.getComp(HeatComponent.class);
            if (component == null) {
                return InteractionResult.PASS;
            }
            IUCore.proxy.messagePlayer(player, Localization.translate("iu.temperature") + String.format("%.2f", component.getEnergy()) + "\u00b0C/" + component.getCapacity() + "\u00b0C");
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

