/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUItem;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuUpgrade;
import com.denfop.datacomponent.ContainerAdditionalItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemStackInventory;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenUpgrade;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class ItemStackUpgradeModules
extends ItemStackInventory {
    public final ItemStack itemStack1;
    public final List<ItemStack> list;
    public final int inventorySize;
    public ContainerAdditionalItem containerAdditionItem;
    public List<FluidStack> fluidStackList;

    public ItemStackUpgradeModules(Player player, ItemStack stack) {
        super(player, stack, 0);
        this.itemStack1 = stack;
        this.inventorySize = 0;
        this.containerAdditionItem = (ContainerAdditionalItem)this.containerStack.get(DataComponentsInit.CONTAINER_ADDITIONAL);
        if (this.containerAdditionItem == null) {
            this.containerAdditionItem = ContainerAdditionalItem.EMPTY.updateItems(this.containerStack, new ArrayList<ItemStack>());
            this.containerStack.set(DataComponentsInit.CONTAINER_ADDITIONAL, (Object)this.containerAdditionItem);
        }
        if (this.containerAdditionItem.listItem().isEmpty()) {
            Object[] object = new ItemStack[9];
            Arrays.fill(object, ItemStack.EMPTY);
            List<Object> list = Arrays.asList(object);
            this.containerAdditionItem = this.containerAdditionItem.updateItems(this.containerStack, list);
        }
        this.list = this.containerAdditionItem.listItem();
        this.fluidStackList = new ArrayList<Object>(Collections.nCopies(9, null));
        if (!IUItem.ejectorUpgrade.is(this.itemStack1.getItem()) && !IUItem.pullingUpgrade.is(this.itemStack1.getItem())) {
            for (int i = 0; i < 9; ++i) {
                IFluidHandlerItem handler;
                FluidStack containerFluid;
                if (this.list.get(i).isEmpty() || (containerFluid = (handler = (IFluidHandlerItem)this.list.get(i).getCapability(Capabilities.FluidHandler.ITEM, null)).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || containerFluid.getAmount() <= 0) continue;
                this.fluidStackList.set(i, new FluidStack(containerFluid.getFluid(), 1));
            }
        }
    }

    public ContainerMenuBase<ItemStackUpgradeModules> getGuiContainer(Player player) {
        return new ContainerMenuUpgrade(this, player);
    }

    @Override
    public ItemStack getItem(int slot) {
        return slot >= this.inventorySize ? this.list.get(slot - this.inventorySize) : (ItemStack)this.inventory.get(slot);
    }

    @Override
    public ItemStack removeItem(int index, int amount) {
        ItemStack stack;
        if (index < this.inventory.size()) {
            ItemStack stack2;
            if (index >= 0 && index < this.inventory.size() && !ModUtils.isEmpty(stack2 = (ItemStack)this.inventory.get(index))) {
                ItemStack ret;
                if (amount >= ModUtils.getSize(stack2)) {
                    ret = stack2;
                    this.inventory.set(index, ModUtils.emptyStack);
                } else {
                    ret = ModUtils.setSize(stack2, amount);
                    this.inventory.set(index, ModUtils.decSize(stack2, amount));
                }
                this.save();
                return ret;
            }
            return ModUtils.emptyStack;
        }
        if (index - this.inventory.size() < this.list.size() && !ModUtils.isEmpty(stack = this.list.get(index - this.inventory.size()))) {
            ItemStack ret;
            if (amount >= ModUtils.getSize(stack)) {
                ret = stack;
                this.list.set(index - this.inventory.size(), ModUtils.emptyStack);
            } else {
                ret = ModUtils.setSize(stack, amount);
                this.list.set(index - this.inventory.size(), ModUtils.decSize(stack, amount));
            }
            this.save();
            return ret;
        }
        return ModUtils.emptyStack;
    }

    public ContainerAdditionalItem getContainerAdditionItem() {
        return this.containerAdditionItem;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        if (slot < this.inventory.size()) {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
                stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
            }
            if (ModUtils.isEmpty(stack)) {
                this.inventory.set(slot, ModUtils.emptyStack);
            } else {
                this.inventory.set(slot, stack);
            }
        } else {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
                stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
            }
            if (ModUtils.isEmpty(stack)) {
                this.list.set(slot - this.inventory.size(), ModUtils.emptyStack);
            } else {
                this.list.set(slot - this.inventory.size(), stack);
            }
        }
        this.save();
    }

    @Override
    protected void save() {
        super.save();
        if (!this.player.level().isClientSide && !this.cleared) {
            boolean dropItself = false;
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.isThisContainer(this.list.get(i))) continue;
                this.list.set(i, ItemStack.EMPTY);
                dropItself = true;
            }
            ListTag contentList = new ListTag();
            this.containerAdditionItem = this.containerAdditionItem.updateItems(this.containerStack, this.list);
            if (dropItself) {
                ModUtils.dropAsEntity(this.player.level(), this.player.blockPosition(), this.containerStack);
                this.clear();
            } else {
                int idx = this.getPlayerInventoryIndex();
                if (idx < -1) {
                    this.clear();
                } else if (idx == -1) {
                    this.player.getInventory().setPickedItem(this.containerStack);
                } else {
                    this.player.getInventory().setItem(idx, this.containerStack);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player player, ContainerMenuBase<?> isAdmin) {
        if (this.itemStack1.is(IUItem.ejectorUpgrade.getItem()) || this.itemStack1.is(IUItem.pullingUpgrade.getItem())) {
            return new ScreenUpgrade((ContainerMenuUpgrade)isAdmin, this.itemStack1);
        }
        return new ScreenUpgrade((ContainerMenuUpgrade)isAdmin, this.itemStack1);
    }

    @Override
    public void addInventorySlot(Inventory var1) {
    }

    @Override
    @Nonnull
    public String getName() {
        return "";
    }

    public boolean hasCustomName() {
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }
}

