/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.Localization;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ItemPlaner
extends Item
implements IItemTab {
    private String nameItem;

    public ItemPlaner() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.planner.info")));
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        IMainMultiBlock mainMultiBlock;
        if (context.getLevel().isClientSide()) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        Direction side = context.getClickedFace();
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IMainMultiBlock && !(mainMultiBlock = (IMainMultiBlock)tile).isFull()) {
            block6: for (Map.Entry<BlockPos, ItemStack> entry : mainMultiBlock.getMultiBlockStucture().ItemStackMap.entrySet()) {
                BlockPlaceContext placeContext;
                if (entry.getValue().isEmpty()) continue;
                Direction rotation = mainMultiBlock.getMultiBlockStucture().RotationMap.get(entry.getKey());
                BlockPos pos1 = switch (((BlockEntityMultiBlockBase)mainMultiBlock).getFacing()) {
                    case Direction.NORTH -> new BlockPos(entry.getKey().getX(), entry.getKey().getY(), entry.getKey().getZ());
                    case Direction.EAST -> new BlockPos(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                    case Direction.WEST -> new BlockPos(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                    case Direction.SOUTH -> new BlockPos(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                    default -> throw new IllegalStateException("Unexpected value: ");
                };
                ItemStack item = entry.getValue();
                if (!player.isCreative()) {
                    for (ItemStack stack1 : player.getInventory().items) {
                        BlockPlaceContext placeContext2;
                        if (!stack1.is(item.getItem())) continue;
                        BlockPos pos2 = pos.offset((Vec3i)pos1);
                        ItemBlockTileEntity item1 = (ItemBlockTileEntity)stack1.getItem();
                        BlockEntity tileEntity = world.getBlockEntity(pos2);
                        if (tileEntity != null || !this.canPlace(world.getBlockState(pos2)) || item1.place(placeContext2 = new BlockPlaceContext(context.getLevel(), context.getPlayer(), context.getHand(), stack1, new BlockHitResult(context.getClickLocation(), context.getClickedFace(), pos2, false))) != InteractionResult.CONSUME) continue;
                        BlockEntityMultiBlockElement tileEntity2 = (BlockEntityMultiBlockElement)world.getBlockEntity(pos2);
                        Direction facing = ((BlockEntityMultiBlockBase)mainMultiBlock).getFacing();
                        rotation = this.adjustRotation(facing, rotation);
                        tileEntity2.setFacing(rotation.getOpposite());
                        continue block6;
                    }
                    continue;
                }
                BlockPos pos2 = pos.offset((Vec3i)pos1);
                ItemBlockTileEntity item1 = (ItemBlockTileEntity)item.getItem();
                BlockEntity tileEntity = world.getBlockEntity(pos2);
                if (tileEntity != null || !this.canPlace(world.getBlockState(pos2)) || item1.place(placeContext = new BlockPlaceContext(context.getLevel(), context.getPlayer(), context.getHand(), context.getItemInHand(), new BlockHitResult(context.getClickLocation(), context.getClickedFace(), pos2, false))) != InteractionResult.SUCCESS) continue;
                BlockEntityMultiBlockElement tileEntity2 = (BlockEntityMultiBlockElement)world.getBlockEntity(pos2);
                Direction facing = ((BlockEntityMultiBlockBase)mainMultiBlock).getFacing();
                rotation = this.adjustRotation(facing, rotation);
                tileEntity2.setFacing(rotation.getOpposite());
            }
            player.containerMenu.broadcastChanges();
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    private Direction adjustRotation(Direction facing, Direction rotation) {
        if (facing == Direction.NORTH) {
            if (rotation == Direction.EAST || rotation == Direction.WEST) {
                rotation = rotation.getOpposite();
            }
        } else if (facing == Direction.SOUTH) {
            if (rotation == Direction.SOUTH || rotation == Direction.NORTH) {
                rotation = rotation.getOpposite();
            }
        } else if (facing == Direction.EAST) {
            rotation = rotation == Direction.EAST || rotation == Direction.WEST ? (rotation == Direction.EAST ? Direction.NORTH : Direction.SOUTH) : (rotation == Direction.SOUTH ? Direction.WEST : Direction.EAST);
        } else if (facing == Direction.WEST) {
            rotation = rotation == Direction.EAST || rotation == Direction.WEST ? (rotation == Direction.WEST ? Direction.NORTH : Direction.SOUTH) : (rotation == Direction.SOUTH ? Direction.EAST : Direction.WEST);
        }
        return rotation == null ? Direction.NORTH : rotation;
    }

    private boolean canPlace(BlockState state) {
        return state.isAir() || state.getBlock() == Blocks.TALL_GRASS || state.liquid();
    }
}

