/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.blocks.BlockRubWood;
import com.denfop.blocks.BlockSwampRubWood;
import com.denfop.blocks.BlockTropicalRubWood;
import com.denfop.blocks.FluidName;
import com.denfop.items.ItemFluidContainer;
import com.denfop.sound.EnumSound;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.Localization;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ItemLatexPipette
extends ItemFluidContainer
implements IItemTab {
    public ItemLatexPipette() {
        super(2000, 1);
    }

    public static boolean attemptExtract(Player player, Level world, BlockPos pos, Direction side, BlockState state, List<ItemStack> stacks, ItemStack stack) {
        if (state.getBlock() != IUItem.rubWood.getBlock().get()) {
            return false;
        }
        BlockRubWood.RubberWoodState rwState = (BlockRubWood.RubberWoodState)((Object)state.getValue(BlockRubWood.stateProperty));
        if (!rwState.isPlain() && rwState.facing == side && FluidHandlerFix.hasFluidHandler(stack) && FluidHandlerFix.getFluidHandler(stack).getFluidInTank(0).getAmount() + 100 <= FluidHandlerFix.getFluidHandler(stack).getTankCapacity(0)) {
            if (rwState.wet) {
                if (!world.isClientSide) {
                    world.setBlock(pos, (BlockState)state.setValue(BlockRubWood.stateProperty, (Comparable)((Object)rwState.getDry())), 3);
                    if (stacks == null) {
                        FluidHandlerFix.getFluidHandler(stack).fill(new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100 * (world.random.nextInt(3) + 1)), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if (world.isClientSide && player != null) {
                    player.playSound(EnumSound.Treetap.getSoundEvent(), 1.0f, 1.0f);
                }
                return true;
            }
            if (!world.isClientSide && world.random.nextInt(5) == 0) {
                world.setBlock(pos, (BlockState)state.setValue(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y)), 3);
            }
            if (world.random.nextInt(5) == 0) {
                if (!world.isClientSide) {
                    FluidHandlerFix.getFluidHandler(stack).fill(new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100), IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean attemptTropicalExtract(Player player, Level world, BlockPos pos, Direction side, BlockState state, List<ItemStack> stacks, ItemStack stack) {
        if (state.getBlock() != IUItem.tropicalRubWood.getBlock().get()) {
            return false;
        }
        BlockTropicalRubWood.RubberWoodState rwState = (BlockTropicalRubWood.RubberWoodState)((Object)state.getValue(BlockTropicalRubWood.stateProperty));
        if (!rwState.isPlain() && rwState.facing == side && FluidHandlerFix.hasFluidHandler(stack) && FluidHandlerFix.getFluidHandler(stack).getFluidInTank(0).getAmount() + 100 <= FluidHandlerFix.getFluidHandler(stack).getTankCapacity(0)) {
            if (rwState.wet) {
                if (!world.isClientSide) {
                    world.setBlock(pos, (BlockState)state.setValue(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rwState.getDry())), 3);
                    if (stacks == null) {
                        FluidHandlerFix.getFluidHandler(stack).fill(new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100 * (world.random.nextInt(3) + 1)), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if (world.isClientSide && player != null) {
                    player.playSound(EnumSound.Treetap.getSoundEvent(), 1.0f, 1.0f);
                }
                return true;
            }
            if (!world.isClientSide && world.random.nextInt(5) == 0) {
                world.setBlock(pos, (BlockState)state.setValue(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.plain_y)), 3);
            }
            if (world.random.nextInt(5) == 0) {
                if (!world.isClientSide) {
                    FluidHandlerFix.getFluidHandler(stack).fill(new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100), IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean attemptSwampExtract(Player player, Level world, BlockPos pos, Direction side, BlockState state, List<ItemStack> stacks, ItemStack stack) {
        if (state.getBlock() != IUItem.swampRubWood.getBlock().get()) {
            return false;
        }
        BlockSwampRubWood.RubberWoodState rwState = (BlockSwampRubWood.RubberWoodState)((Object)state.getValue(BlockSwampRubWood.stateProperty));
        if (!rwState.isPlain() && rwState.facing == side && FluidHandlerFix.hasFluidHandler(stack) && FluidHandlerFix.getFluidHandler(stack).getFluidInTank(0).getAmount() + 100 <= FluidHandlerFix.getFluidHandler(stack).getTankCapacity(0)) {
            if (rwState.wet) {
                if (!world.isClientSide) {
                    world.setBlock(pos, (BlockState)state.setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)rwState.getDry())), 3);
                    if (stacks == null) {
                        FluidHandlerFix.getFluidHandler(stack).fill(new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100 * (world.random.nextInt(3) + 1)), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if (world.isClientSide && player != null) {
                    player.playSound(EnumSound.Treetap.getSoundEvent(), 1.0f, 1.0f);
                }
                return true;
            }
            if (!world.isClientSide && world.random.nextInt(5) == 0) {
                world.setBlock(pos, (BlockState)state.setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)), 3);
            }
            if (world.random.nextInt(5) == 0) {
                if (!world.isClientSide) {
                    FluidHandlerFix.getFluidHandler(stack).fill(new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100), IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, level, list, tooltipFlag);
        list.add((Component)Component.literal((String)Localization.translate("iu.latex_pipette.info")));
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        BlockState state = world.getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        if (state.getBlock() == IUItem.rubWood.getBlock().get()) {
            if (ItemLatexPipette.attemptExtract(player, world, pos, side, state, null, stack)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (state.getBlock() == IUItem.swampRubWood.getBlock().get()) {
            if (ItemLatexPipette.attemptSwampExtract(player, world, pos, side, state, null, stack)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (state.getBlock() == IUItem.tropicalRubWood.getBlock().get()) {
            if (ItemLatexPipette.attemptTropicalExtract(player, world, pos, side, state, null, stack)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return fluid == FluidName.fluidrawlatex.getInstance().get();
    }
}

