/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.tabs.IItemTab;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemFoodIU
extends Item
implements IItemTab {
    private final String name;
    private final String path;
    private String nameItem;

    public ItemFoodIU(String name, int amount, float saturation) {
        this(name, "", amount, saturation);
    }

    public ItemFoodIU(String name, int amount, float saturation, boolean edible) {
        super(new Item.Properties().food(new FoodProperties.Builder().nutrition(amount).saturationModifier(saturation).alwaysEdible().build()));
        this.name = name;
        this.path = "";
    }

    public ItemFoodIU(String name, String path, int amount, float saturation) {
        super(new Item.Properties().food(new FoodProperties.Builder().nutrition(amount).saturationModifier(saturation).build()));
        this.name = name;
        this.path = path;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.CropsTab;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[1] + ".name";
        }
        return this.nameItem;
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity player) {
        if (!world.isClientSide && stack.getItem() == IUItem.terra_wart.getItem()) {
            for (MobEffectInstance effect : new ArrayList(player.getActiveEffects())) {
                Holder potion = effect.getEffect();
                if (((MobEffect)potion.value()).isBeneficial()) continue;
                player.removeEffect(potion);
            }
        }
        return super.finishUsingItem(stack, world, player);
    }
}

