/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.items.ContainerMenuFacadeItem;
import com.denfop.items.FacadeItemInventory;
import com.denfop.items.IItemStackInventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemFacadeItem
extends Item
implements IItemStackInventory,
IItemTab {
    private final int slots;
    private String nameItem;

    public ItemFacadeItem() {
        super(new Item.Properties().stacksTo(1));
        this.slots = 1;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.facadeitem";
        }
        return this.nameItem;
    }

    @Override
    public CustomWorldContainer getInventory(Player player, ItemStack stack) {
        return new FacadeItemInventory(player, stack, this.slots);
    }

    public void save(ItemStack stack, Player player) {
        ContainerItem containerItem = ContainerItem.getContainer(stack);
        containerItem = containerItem.updateOpen(stack, true);
        containerItem.updateSlot(stack, player.getInventory().selected);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        FacadeItemInventory toolbox;
        int slotId;
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ContainerItem containerItem = ContainerItem.getContainer(stack);
        if (containerItem.open() && (slotId = containerItem.slot_inventory()) != itemSlot && !world.isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerMenuFacadeItem && (toolbox = (FacadeItemInventory)((ContainerMenuFacadeItem)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.closeContainer();
            containerItem.updateOpen(stack, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext world, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, world, tooltip, flag);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        FacadeItemInventory toolbox;
        if (!player.level().isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerMenuFacadeItem && (toolbox = (FacadeItemInventory)((ContainerMenuFacadeItem)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.closeContainer();
        }
        return true;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        BlockHitResult blockhitresult = ItemFacadeItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (!player.level().isClientSide && world.getBlockEntity(blockhitresult.getBlockPos()) == null) {
            this.save(stack, player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer(player.registryAccess());
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            player.openMenu((MenuProvider)this.getInventory(player, player.getItemInHand(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public boolean canInsert(Player player, ItemStack stack, ItemStack stack1) {
        return true;
    }
}

