/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EFReaderInventory;
import com.denfop.items.IItemStackInventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.screen.ScreenEFReader;
import com.denfop.tabs.IItemTab;
import io.netty.buffer.ByteBuf;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemEFReader
extends Item
implements IItemStackInventory,
IUpdatableItemStackEvent,
IItemTab {
    private String nameItem;

    public ItemEFReader() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
        if (Minecraft.getInstance().screen instanceof ScreenEFReader) {
            ScreenEFReader screenEFReader = (ScreenEFReader)Minecraft.getInstance().screen;
            screenEFReader.readField(name, buffer);
        }
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
    }

    @Override
    public CustomWorldContainer getInventory(Player var1, ItemStack var2) {
        return new EFReaderInventory(var1, var2);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        if (!world.isClientSide) {
            if (EnergyNetGlobal.instance.getTile(world, pos) != EnergyNetGlobal.EMPTY) {
                player.getItemInHand(context.getHand()).set(DataComponentsInit.TELEPORT, (Object)pos);
                CustomPacketBuffer growingBuffer = new CustomPacketBuffer(player.registryAccess());
                growingBuffer.writeByte(1);
                growingBuffer.flip();
                player.openMenu((MenuProvider)this.getInventory(player, player.getItemInHand(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
                return InteractionResult.SUCCESS;
            }
            IUCore.proxy.messagePlayer(player, "This block isn`t energyTile");
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

