/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.Localization;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemDeplanner
extends Item
implements IItemTab {
    private String nameItem;

    public ItemDeplanner() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.deplanner.info")));
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos pos;
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockEntity tile = world.getBlockEntity(pos = context.getClickedPos());
        if (tile instanceof IMainMultiBlock && !world.isClientSide) {
            IMainMultiBlock mainMultiBlock = (IMainMultiBlock)tile;
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
            if (mainMultiBlock.isFull()) {
                for (Map.Entry<BlockPos, ItemStack> entry : mainMultiBlock.getMultiBlockStucture().ItemStackMap.entrySet()) {
                    if (entry.getKey().equals((Object)BlockPos.ZERO) || entry.getValue().isEmpty()) continue;
                    BlockPos pos1 = switch (((BlockEntityMultiBlockBase)mainMultiBlock).getFacing()) {
                        case Direction.NORTH -> new BlockPos(entry.getKey().getX(), entry.getKey().getY(), entry.getKey().getZ());
                        case Direction.EAST -> new BlockPos(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                        case Direction.WEST -> new BlockPos(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                        case Direction.SOUTH -> new BlockPos(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                        default -> throw new IllegalStateException("Unexpected value: ");
                    };
                    BlockEntityBase block = (BlockEntityBase)world.getBlockEntity(pos.offset((Vec3i)pos1));
                    itemStackList.add(block.getPickBlock(null, null));
                    world.removeBlockEntity(pos.offset((Vec3i)pos1));
                    world.setBlock(pos.offset((Vec3i)pos1), Blocks.AIR.defaultBlockState(), 3);
                }
                itemStackList.add(mainMultiBlock.getMultiBlockStucture().ItemStackMap.get(BlockPos.ZERO).copy());
                ((BlockEntityMultiBlockBase)mainMultiBlock).onUnloaded();
                world.removeBlockEntity(pos);
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                if (!world.isClientSide) {
                    for (ItemStack stack1 : itemStackList) {
                        ItemEntity entityItem = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), stack1);
                        entityItem.setPickUpDelay(0);
                        world.addFreshEntity((Entity)entityItem);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

