/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ModUtils;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BaseEnergyItem
extends Item
implements EnergyItem,
IItemTab {
    protected final double maxCharge;
    protected final double transferLimit;
    protected final int tier;
    protected String nameItem;

    public BaseEnergyItem(double maxCharge, double transferLimit, int tier) {
        super(new Item.Properties().setNoRepair().stacksTo(1).component(DataComponentsInit.ENERGY, (Object)0.0));
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
    }

    public BaseEnergyItem(Item.Properties properties, double maxCharge, double transferLimit, int tier) {
        super(properties.setNoRepair().stacksTo(1).component(DataComponentsInit.ENERGY, (Object)0.0));
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ItemStack var4 = new ItemStack((ItemLike)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            p_41392_.add((Object)var4);
            p_41392_.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }
}

