/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.blockentity.base.BlockEntityBaseWorldCollector;
import com.denfop.blocks.ISubEnum;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemSolidMatter;
import net.minecraft.world.item.ItemStack;

public class InventoryWorldCollector
extends Inventory {
    private final BlockEntityBaseWorldCollector tile;

    public InventoryWorldCollector(BlockEntityBaseWorldCollector base1) {
        super(base1, Inventory.TypeItemSlot.INPUT, 1);
        this.tile = base1;
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.getmatter();
        BlockEntityBaseWorldCollector tile = (BlockEntityBaseWorldCollector)this.base;
        if (tile.getRecipeOutput() != null) {
            tile.getrequiredmatter(tile.getRecipeOutput().getRecipe().getOutput());
        }
        return content;
    }

    public void getmatter() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty()) continue;
            int col = 50;
            col = (int)((double)col - Math.ceil(this.tile.matter_energy / 200.0));
            col = Math.min(col, this.get(i).getCount());
            this.tile.matter_energy += (double)(200 * col);
            this.consume(i, col);
        }
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack itemStack) {
        return itemStack.getItem() instanceof ItemSolidMatter && ((ISubEnum)((ItemSolidMatter)itemStack.getItem()).getElement()).getId() == this.tile.enumTypeCollector.getMeta();
    }

    public void consume(int content, int amount) {
        this.consume(content, amount, false);
    }

    public void consume(int content, int amount, boolean simulate) {
        ItemStack stack = this.get(content);
        if (!stack.isEmpty() && amount > 0) {
            int currentAmount = Math.min(amount, stack.getCount());
            if (!simulate) {
                stack.shrink(currentAmount);
            }
        }
    }
}

