/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.IUItem;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.FakePlayerSpawner;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.Redstone;
import com.denfop.datacomponent.ContainerAdditionalItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.inventory.HandlerInventory;
import com.denfop.inventory.Inventory;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.ItemStackUpgradeModules;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class InventoryUpgrade
extends Inventory
implements ITypeSlot {
    private final BlockEntityInventory tile;
    private final Map<Direction, HandlerInventory> iItemHandlerMap;
    private final Map<IItemHandler, Integer> slotHandler;
    private final Direction[] enumFacings = Direction.values();
    private final Map<Direction, IFluidHandler> iFluidHandlerMap;
    private final Fluids fluids;
    private final List<Fluids.InternalFluidTank> fluidTankList = new ArrayList<Fluids.InternalFluidTank>();
    private final IItemHandler main_handler;
    public boolean isUpdate = false;
    public int extraProcessTime;
    public double processTimeMultiplier;
    public double extraEnergyDemand;
    public double energyDemandMultiplier;
    public double extraEnergyStorage;
    public double operationsPerTick;
    public double operationLength;
    public double energyConsume;
    public double energyStorageMultiplier;
    public int extraTier;
    public int tick = 0;
    public boolean update = false;
    List<InventoryOutput> slots = new ArrayList<InventoryOutput>();
    List<Inventory> inv_slots = new ArrayList<Inventory>();
    private Direction[] facings;
    private List<List<ItemStack>> whiteList;
    private List<List<Fluid>> whiteList1;
    private boolean ejectorUpgrade;
    private boolean fluidEjectorUpgrade;
    private boolean pullingUpgrade;
    private boolean fluidPullingUpgrade;
    FakePlayerSpawner player;

    public InventoryUpgrade(BlockEntityInventory base, int count) {
        super(base, Inventory.TypeItemSlot.INPUT, count);
        this.resetRates();
        this.facings = new Direction[count];
        this.whiteList = new ArrayList(Collections.nCopies(count, Collections.emptyList()));
        this.whiteList1 = new ArrayList(Collections.nCopies(count, Collections.emptyList()));
        base.getInvSlots().forEach(slot -> {
            if (slot instanceof InventoryOutput) {
                this.slots.add((InventoryOutput)slot);
            }
        });
        base.getInvSlots().forEach(slot -> {
            if (slot.canInput()) {
                this.inv_slots.add((Inventory)slot);
            }
        });
        this.main_handler = (IItemHandler)base.getCapability(Capabilities.ItemHandler.BLOCK, base.getFacing());
        this.fluids = base.getComp(Fluids.class);
        if (this.fluids != null) {
            this.fluids.getAllTanks().forEach(this.fluidTankList::add);
        }
        this.tile = base;
        this.slotHandler = new HashMap<IItemHandler, Integer>();
        this.iItemHandlerMap = new HashMap<Direction, HandlerInventory>();
        this.iFluidHandlerMap = new HashMap<Direction, IFluidHandler>();
    }

    private static int applyModifier(int base, int extra) {
        double ret = Math.round((double)base + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(double base, double extra, double multiplier) {
        return Math.round((base + extra) * multiplier);
    }

    public static Direction getDirection(ItemStack stack) {
        byte rawDir = (Byte)stack.getOrDefault(DataComponentsInit.DIRECTION, (Object)0);
        return rawDir >= 1 && rawDir <= 6 ? Direction.values()[rawDir - 1] : null;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        return EnumTypeSlot.UPGRADE;
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        Item rawItem = stack.getItem();
        if (!(rawItem instanceof IUpgradeItem)) {
            return false;
        }
        IUpgradeItem item = (IUpgradeItem)rawItem;
        return item.isSuitableFor(stack, ((IUpgradableBlock)((Object)this.base)).getUpgradableProperties());
    }

    @Override
    public boolean add(List<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    @Override
    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    @Override
    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    @Override
    public void setChanged() {
        this.resetRates();
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = this.get(i);
            if (ModUtils.isEmpty(itemStack)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)itemStack.getItem();
            int size = ModUtils.getSize(itemStack);
            this.extraProcessTime = upgrade.getProcessTimeMultiplier(itemStack) < 1.0 ? (this.extraProcessTime += size) : 0;
            this.processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(itemStack), size);
            this.extraEnergyDemand = upgrade.getProcessTimeMultiplier(itemStack) < 1.0 ? (this.extraEnergyDemand += (double)size) : 0.0;
            this.energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(itemStack), size) * this.operationsPerTick;
            this.extraEnergyStorage += upgrade.getExtraEnergyStorage(itemStack) * (double)size;
            this.energyStorageMultiplier *= Math.pow(1.0, size);
            this.extraTier += upgrade.getExtraTier(itemStack) * size;
        }
        for (AbstractComponent abstractComponent : ((BlockEntityInventory)this.base).getComps()) {
            if (!(abstractComponent instanceof Redstone)) continue;
            Redstone rs = (Redstone)abstractComponent;
            rs.update();
        }
        if (this.tile.getWorld() instanceof ServerLevel) {
            if (this.player == null) {
                this.player = new FakePlayerSpawner(this.tile.getWorld());
            }
            for (int i = 0; i < this.size(); ++i) {
                ArrayList<Fluid> fluidStacks1;
                List<FluidStack> fluidStacks;
                List<Object> stacks;
                IItemStackInventory inventory;
                ItemStack itemStack = this.get(i);
                if (itemStack.is(IUItem.ejectorUpgrade.getItem())) {
                    this.ejectorUpgrade = true;
                    this.facings[i] = InventoryUpgrade.getDirection(itemStack);
                    inventory = (IItemStackInventory)itemStack.getItem();
                    stacks = ((ContainerAdditionalItem)itemStack.getOrDefault(DataComponentsInit.CONTAINER_ADDITIONAL, (Object)ContainerAdditionalItem.EMPTY)).listItem();
                    stacks = stacks.stream().filter(stack1 -> !stack1.isEmpty()).collect(Collectors.toList());
                    this.whiteList.set(i, stacks);
                    continue;
                }
                if (itemStack.is(IUItem.fluidEjectorUpgrade.getItem())) {
                    this.fluidEjectorUpgrade = true;
                    this.facings[i] = InventoryUpgrade.getDirection(itemStack);
                    inventory = (IItemStackInventory)itemStack.getItem();
                    fluidStacks = ((ItemStackUpgradeModules)inventory.getInventory((Player)this.player, (ItemStack)itemStack)).fluidStackList;
                    fluidStacks1 = new ArrayList<Fluid>();
                    for (FluidStack stacks2 : fluidStacks) {
                        if (stacks2 == null || !stacks2.isEmpty()) continue;
                        fluidStacks1.add(stacks2.getFluid());
                    }
                    this.whiteList1.set(i, fluidStacks1);
                    continue;
                }
                if (itemStack.is(IUItem.pullingUpgrade.getItem())) {
                    this.pullingUpgrade = true;
                    this.facings[i] = InventoryUpgrade.getDirection(itemStack);
                    inventory = (IItemStackInventory)itemStack.getItem();
                    stacks = ((ContainerAdditionalItem)itemStack.getOrDefault(DataComponentsInit.CONTAINER_ADDITIONAL, (Object)ContainerAdditionalItem.EMPTY)).listItem();
                    stacks = stacks.stream().filter(stack1 -> !stack1.isEmpty()).collect(Collectors.toList());
                    this.whiteList.set(i, stacks);
                    continue;
                }
                if (!itemStack.is(IUItem.fluidpullingUpgrade.getItem())) continue;
                this.fluidPullingUpgrade = true;
                this.facings[i] = InventoryUpgrade.getDirection(itemStack);
                inventory = (IItemStackInventory)itemStack.getItem();
                fluidStacks = ((ItemStackUpgradeModules)inventory.getInventory((Player)this.player, (ItemStack)itemStack)).fluidStackList;
                fluidStacks1 = new ArrayList();
                for (FluidStack stacks2 : fluidStacks) {
                    if (stacks2 == null || !stacks2.isEmpty()) continue;
                    fluidStacks1.add(stacks2.getFluid());
                }
                this.whiteList1.set(i, fluidStacks1);
            }
        }
    }

    private void resetRates() {
        this.extraProcessTime = 0;
        this.processTimeMultiplier = 1.0;
        this.extraEnergyDemand = 0.0;
        this.energyDemandMultiplier = 1.0;
        this.extraEnergyStorage = 0.0;
        this.energyStorageMultiplier = 1.0;
        this.extraTier = 0;
        this.ejectorUpgrade = false;
        this.fluidEjectorUpgrade = false;
        this.fluidPullingUpgrade = false;
        this.pullingUpgrade = false;
        this.facings = new Direction[this.size()];
    }

    public int getOperationsPerTick1(int defaultOperationLength) {
        if (this.isUpdate) {
            this.operationsPerTick = defaultOperationLength == 0 ? 64.0 : (double)this.getOpsPerTick(this.getStackOpLen(defaultOperationLength));
        }
        return (int)this.operationsPerTick;
    }

    public int getOperationLength1(int defaultOperationLength) {
        if (this.isUpdate) {
            if (defaultOperationLength == 0) {
                this.operationLength = 1.0;
            } else {
                double stackOpLen = this.getStackOpLen(defaultOperationLength);
                int opsPerTick = this.getOpsPerTick(stackOpLen);
                this.operationLength = Math.max(1, (int)Math.round(stackOpLen * (double)opsPerTick / 64.0));
            }
        }
        return (int)this.operationLength;
    }

    public int getOperationsPerTick(int defaultOperationLength) {
        this.operationsPerTick = defaultOperationLength == 0 ? 64.0 : (double)this.getOpsPerTick(this.getStackOpLen(defaultOperationLength));
        return (int)this.operationsPerTick;
    }

    public int getOperationLength(int defaultOperationLength) {
        if (defaultOperationLength == 0) {
            this.operationLength = 1.0;
        } else {
            double stackOpLen = this.getStackOpLen(defaultOperationLength);
            int opsPerTick = this.getOpsPerTick(stackOpLen);
            this.operationLength = Math.max(1, (int)Math.round(stackOpLen * (double)opsPerTick / 64.0));
        }
        return (int)this.operationLength;
    }

    private double getStackOpLen(int defaultOperationLength) {
        return ((double)defaultOperationLength + (double)this.extraProcessTime) * 64.0 * this.processTimeMultiplier;
    }

    private int getOpsPerTick(double stackOpLen) {
        return (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
    }

    public double getEnergyDemand(int defaultEnergyDemand) {
        return InventoryUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
    }

    public double getEnergyDemand(double defaultEnergyDemand) {
        this.energyConsume = InventoryUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
        return this.energyConsume;
    }

    public double getEnergyDemand1(double defaultEnergyDemand) {
        if (this.isUpdate) {
            this.energyConsume = InventoryUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
        }
        return this.energyConsume;
    }

    public double getEnergyStorage(int defaultEnergyStorage) {
        return InventoryUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage, this.energyStorageMultiplier);
    }

    public double getEnergyStorage(double defaultEnergyStorage) {
        return InventoryUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage, this.energyStorageMultiplier);
    }

    public int getTier(int defaultTier) {
        return InventoryUpgrade.applyModifier(defaultTier, this.extraTier);
    }

    public boolean tickNoMark() {
        boolean ret = false;
        ++this.tick;
        if (this.tick % 20 == 0) {
            BlockPos pos;
            if (this.ejectorUpgrade || this.pullingUpgrade) {
                this.iItemHandlerMap.clear();
                this.slotHandler.clear();
                for (Direction facing : this.enumFacings) {
                    pos = this.tile.getBlockPos().offset(facing.getNormal());
                    BlockEntity tile1 = this.tile.getLevel().getBlockEntity(pos);
                    IItemHandler handler = this.getItemHandler(pos, this.base.getWorld(), facing.getOpposite());
                    if (!(tile1 instanceof Container)) {
                        if (handler == null) {
                            this.iItemHandlerMap.put(facing, null);
                        } else {
                            this.iItemHandlerMap.put(facing, new HandlerInventory(handler, null));
                        }
                    } else {
                        this.iItemHandlerMap.put(facing, new HandlerInventory(handler, (Container)tile1));
                    }
                    if (handler == null) continue;
                    this.slotHandler.put(handler, handler.getSlots());
                }
            }
            if (this.fluidEjectorUpgrade || this.fluidPullingUpgrade) {
                this.iFluidHandlerMap.clear();
                for (Direction facing : this.enumFacings) {
                    pos = this.tile.getBlockPos().offset(facing.getNormal());
                    IFluidHandler handler = this.getFluidHandler(pos, this.tile.getLevel(), facing.getOpposite());
                    this.iFluidHandlerMap.put(facing, handler);
                }
            }
            this.tick = 0;
        }
        boolean update = false;
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = this.get(i);
            if (ModUtils.isEmpty(stack) || !(stack.getItem() instanceof IUpgradeItem)) continue;
            update = true;
            if (this.tick % 2 == 0 && stack.is(IUItem.ejectorUpgrade.getItem())) {
                this.tick(i);
            } else if (this.tick % 2 == 0 && stack.is(IUItem.fluidEjectorUpgrade.getItem())) {
                this.tick_fluid(i);
            } else if (this.tick % 2 == 0 && stack.is(IUItem.pullingUpgrade.getItem())) {
                this.tickPullIn(i);
            } else if (this.tick % 2 == 0 && stack.is(IUItem.fluidpullingUpgrade.getItem())) {
                this.tickPullIn_fluid(i);
            }
            ret = true;
        }
        if (this.update != update) {
            this.update = update;
            return true;
        }
        return ret;
    }

    private void tickPullIn_fluid(int i) {
        Direction facing = this.facings[i];
        List<Fluid> itemStackList = this.whiteList1.get(i);
        if (facing != null) {
            IFluidHandler handler = this.iFluidHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (this.fluids == null) {
                return;
            }
            if (handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                return;
            }
            for (int ii = 0; ii < handler.getTanks(); ++ii) {
                @NotNull FluidStack fluidTankProperties = handler.getFluidInTank(ii);
                if (fluidTankProperties.copy().isEmpty()) continue;
                for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                    FluidStack fluid;
                    if (tank.getFluidAmount() >= tank.getCapacity() || (fluid = handler.drain(fluidTankProperties.copy(), IFluidHandler.FluidAction.SIMULATE)).isEmpty() || fluid.getAmount() <= 0 || !tank.canDrain(facing.getOpposite()) || !tank.isFluidValid(fluid) || !itemStackList.isEmpty() && !itemStackList.contains(fluid.getFluid())) continue;
                    FluidStack fluidStack = fluidTankProperties.copy();
                    fluidStack.setAmount(Math.min(tank.getCapacity() - tank.getFluidAmount(), fluidStack.getAmount()));
                    handler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        } else {
            for (Direction facing1 : this.enumFacings) {
                IFluidHandler handler = this.iFluidHandlerMap.get(facing1);
                if (handler == null || handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
                if (this.fluids == null) {
                    return;
                }
                for (int ii = 0; ii < handler.getTanks(); ++ii) {
                    @NotNull FluidStack fluidTankProperties = handler.getFluidInTank(ii);
                    if (fluidTankProperties.copy().isEmpty()) continue;
                    for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                        FluidStack fluid;
                        if (tank.getFluidAmount() >= tank.getCapacity() || (fluid = handler.drain(fluidTankProperties.copy(), IFluidHandler.FluidAction.SIMULATE)).isEmpty() || fluid.getAmount() <= 0 || !tank.acceptsFluid(fluid.getFluid()) || !itemStackList.isEmpty() && !itemStackList.contains(fluid.getFluid())) continue;
                        FluidStack fluidStack = fluidTankProperties.copy();
                        fluidStack.setAmount(Math.min(tank.getCapacity() - tank.getFluidAmount(), fluidStack.getAmount()));
                        handler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            }
        }
    }

    public IItemHandler getItemHandler(BlockPos pos, Level level, Direction side) {
        if (this.tile == null) {
            return null;
        }
        IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side);
        return handler;
    }

    public IFluidHandler getFluidHandler(@Nullable BlockPos pos, Level level, Direction side) {
        if (this.tile == null) {
            return null;
        }
        return (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)side);
    }

    public boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.isEmpty() || a.getItem() != b.getItem() || a.getComponents().isEmpty() != b.getComponents().isEmpty()) {
            return false;
        }
        return a.getComponents().isEmpty() || a.getComponents().equals((Object)b.getComponents());
    }

    private void tickPullIn(int i) {
        Direction facing = this.facings[i];
        List<ItemStack> itemStackList = this.whiteList.get(i);
        if (facing != null) {
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (handler.getInventory() != null && handler.getInventory() instanceof BlockEntityInventory) {
                List<Inventory> inputs = ((BlockEntityInventory)this.base).getInputSlots();
                BlockEntityInventory inventory = (BlockEntityInventory)handler.getInventory();
                List<Inventory> outputs = inventory.getOutputSlots();
                for (Inventory slot : outputs) {
                    for (Inventory invSlot : inputs) {
                        ItemStack input;
                        if (invSlot.acceptAllOrIndex()) {
                            for (int j = 0; j < slot.size(); ++j) {
                                ItemStack output = slot.get(j);
                                if (output.isEmpty()) continue;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    for (ItemStack stack : itemStackList) {
                                        if (stack.getItem() != output.getItem()) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue;
                                }
                                if (!invSlot.canPlaceItem(0, output)) continue;
                                for (int jj = 0; jj < invSlot.size() && !output.isEmpty(); ++jj) {
                                    int maxCount;
                                    input = invSlot.get(jj);
                                    if (input.isEmpty()) {
                                        if (!invSlot.add(output)) continue;
                                        slot.set(j, ItemStack.EMPTY);
                                        output = ItemStack.EMPTY;
                                        continue;
                                    }
                                    if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                    input.grow(maxCount);
                                    output.shrink(maxCount);
                                }
                            }
                            continue;
                        }
                        block9: for (int jj = 0; jj < slot.size(); ++jj) {
                            ItemStack output;
                            for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).isEmpty(); ++j) {
                                int maxCount;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    input = itemStackList.iterator();
                                    while (input.hasNext()) {
                                        ItemStack stack = (ItemStack)input.next();
                                        if (stack.getItem() != output.getItem()) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue block9;
                                }
                                if ((input = invSlot.get(j)).isEmpty()) {
                                    if (!invSlot.canPlaceItem(j, output) || !invSlot.add(output)) continue;
                                    slot.set(jj, ItemStack.EMPTY);
                                    output = ItemStack.EMPTY;
                                    continue;
                                }
                                if (output.getItem() != input.getItem() || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                input.grow(maxCount);
                                output.shrink(maxCount);
                            }
                        }
                    }
                }
            } else {
                int slots = 0;
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                for (int j = 0; j < slots; ++j) {
                    ItemStack took1;
                    ItemStack took = handler.getHandler().extractItem(j, 64, true);
                    if (took.isEmpty()) continue;
                    boolean find = false;
                    if (!itemStackList.isEmpty()) {
                        for (ItemStack stack : itemStackList) {
                            if (!stack.is(took.getItem())) continue;
                            find = true;
                            break;
                        }
                        if (!find) continue;
                    }
                    if ((took1 = ModUtils.insertItem(this.main_handler, took, true, this.main_handler.getSlots())).isEmpty()) {
                        took = handler.getHandler().extractItem(j, took.getCount(), false);
                        ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                        continue;
                    }
                    if (took1 == took) continue;
                    int count = took1.getCount() - took.getCount();
                    count = Math.abs(count);
                    took = handler.getHandler().extractItem(j, count, false);
                    ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                }
            }
        } else {
            for (Direction facing1 : this.enumFacings) {
                HandlerInventory handler = this.iItemHandlerMap.get(facing1);
                if (handler == null) continue;
                if (handler.getInventory() != null && handler.getInventory() instanceof BlockEntityInventory) {
                    List<Inventory> inputs = ((BlockEntityInventory)this.base).getInputSlots();
                    BlockEntityInventory inventory = (BlockEntityInventory)handler.getInventory();
                    List<Inventory> outputs = inventory.getOutputSlots();
                    for (Inventory slot : outputs) {
                        for (Inventory invSlot : inputs) {
                            ItemStack input;
                            if (invSlot.acceptAllOrIndex()) {
                                for (int j = 0; j < slot.size(); ++j) {
                                    ItemStack output = slot.get(j);
                                    if (output.isEmpty()) continue;
                                    boolean find = false;
                                    if (!itemStackList.isEmpty()) {
                                        for (ItemStack stack : itemStackList) {
                                            if (!stack.is(output.getItem())) continue;
                                            find = true;
                                            break;
                                        }
                                        if (!find) continue;
                                    }
                                    if (!invSlot.canPlaceItem(0, output)) continue;
                                    for (int jj = 0; jj < invSlot.size() && !output.isEmpty(); ++jj) {
                                        int maxCount;
                                        input = invSlot.get(jj);
                                        if (input.isEmpty()) {
                                            if (!invSlot.add(output)) continue;
                                            slot.set(j, ItemStack.EMPTY);
                                            output = ItemStack.EMPTY;
                                            continue;
                                        }
                                        if (!output.is(input.getItem()) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                        input.grow(maxCount);
                                        output.shrink(maxCount);
                                    }
                                }
                                continue;
                            }
                            block20: for (int jj = 0; jj < slot.size(); ++jj) {
                                ItemStack output;
                                for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).isEmpty(); ++j) {
                                    int maxCount;
                                    boolean find = false;
                                    if (!itemStackList.isEmpty()) {
                                        input = itemStackList.iterator();
                                        while (input.hasNext()) {
                                            ItemStack stack = (ItemStack)input.next();
                                            if (!stack.is(output.getItem())) continue;
                                            find = true;
                                            break;
                                        }
                                        if (!find) continue block20;
                                    }
                                    if ((input = invSlot.get(j)).isEmpty()) {
                                        if (!invSlot.canPlaceItem(j, output) || !invSlot.add(output)) continue;
                                        slot.set(jj, ItemStack.EMPTY);
                                        output = ItemStack.EMPTY;
                                        continue;
                                    }
                                    if (!output.is(input.getItem()) || input.getCount() == input.getMaxStackSize() || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                    input.grow(maxCount);
                                    output.shrink(maxCount);
                                }
                            }
                        }
                    }
                    continue;
                }
                int slots = 0;
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                for (int j = 0; j < slots; ++j) {
                    ItemStack took = handler.getHandler().extractItem(j, 64, true);
                    if (took.isEmpty()) continue;
                    ItemStack took1 = ModUtils.insertItem(this.main_handler, took, true, this.main_handler.getSlots());
                    if (took1.isEmpty()) {
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack : itemStackList) {
                                if (!stack.is(took.getItem())) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        took = handler.getHandler().extractItem(j, took.getCount(), false);
                        ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                        continue;
                    }
                    if (took1 == took) continue;
                    int count = took1.getCount() - took.getCount();
                    count = Math.abs(count);
                    took = handler.getHandler().extractItem(j, count, false);
                    ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                }
            }
        }
    }

    private void tick(int i) {
        Direction facing = this.facings[i];
        List<ItemStack> itemStackList = this.whiteList.get(i);
        if (facing != null) {
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            int slots = 0;
            if (handler.getInventory() != null && handler.getInventory() instanceof BlockEntityInventory) {
                BlockEntityInventory inventory = (BlockEntityInventory)handler.getInventory();
                for (InventoryOutput slot : this.slots) {
                    for (Inventory invSlot : inventory.getInputSlots()) {
                        if (invSlot.acceptAllOrIndex()) {
                            for (int j = 0; j < slot.size(); ++j) {
                                ItemStack output = slot.get(j);
                                if (output.isEmpty()) continue;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    for (ItemStack stack : itemStackList) {
                                        if (!stack.is(output.getItem())) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue;
                                }
                                if (!invSlot.canPlaceItem(0, output)) continue;
                                for (int jj = 0; jj < invSlot.size() && !output.isEmpty(); ++jj) {
                                    int maxCount;
                                    ItemStack input = invSlot.get(jj);
                                    if (input.isEmpty()) {
                                        if (!invSlot.add(output)) continue;
                                        slot.set(j, ItemStack.EMPTY);
                                        output = ItemStack.EMPTY;
                                        continue;
                                    }
                                    if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                    input.grow(maxCount);
                                    output.shrink(maxCount);
                                }
                            }
                            continue;
                        }
                        block9: for (int jj = 0; jj < slot.size(); ++jj) {
                            for (int j = 0; j < invSlot.size(); ++j) {
                                int maxCount;
                                ItemStack output = slot.get(jj);
                                ItemStack input = invSlot.get(j);
                                if (output.isEmpty()) continue block9;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    for (ItemStack stack : itemStackList) {
                                        if (!stack.is(output.getItem())) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue block9;
                                }
                                if (input.isEmpty()) {
                                    if (!invSlot.canPlaceItem(j, output) || !invSlot.add(output)) continue;
                                    slot.set(jj, ItemStack.EMPTY);
                                    output = ItemStack.EMPTY;
                                    continue;
                                }
                                if (!output.is(input.getItem()) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                input.grow(maxCount);
                                output.shrink(maxCount);
                            }
                        }
                    }
                }
            } else {
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (handler.getInventory() != null) {
                    for (InventoryOutput slot : this.slots) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack stack;
                            ItemStack took = slot.get(j);
                            if (took.isEmpty()) continue;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack2 : itemStackList) {
                                    if (!stack2.is(took.getItem())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue;
                            }
                            if ((stack = this.insertItem1(handler, took, true, slots)).isEmpty()) {
                                slot.set(j, ItemStack.EMPTY);
                                this.insertItem1(handler, took, false, slots);
                                continue;
                            }
                            if (stack == took) continue;
                            int col = slot.get(j).getCount() - stack.getCount();
                            slot.get(j).shrink(col);
                            stack.setCount(col);
                            this.insertItem1(handler, stack, false, slots);
                        }
                    }
                } else {
                    for (InventoryOutput slot : this.slots) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack took = slot.get(j);
                            if (took.isEmpty()) continue;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack : itemStackList) {
                                    if (!stack.is(took.getItem())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue;
                            }
                            took = took.copy();
                            ItemStack stack = ModUtils.insertItem(handler.getHandler(), took, true, slots);
                            if (stack.isEmpty()) {
                                slot.set(j, ItemStack.EMPTY);
                                ModUtils.insertItem(handler.getHandler(), took, false, slots);
                                continue;
                            }
                            if (stack == took) continue;
                            int col = slot.get(j).getCount() - stack.getCount();
                            slot.get(j).shrink(col);
                            stack.setCount(col);
                            ModUtils.insertItem(handler.getHandler(), stack, false, slots);
                        }
                    }
                }
            }
        } else {
            for (Direction facing1 : this.enumFacings) {
                ItemStack took;
                HandlerInventory handler = this.iItemHandlerMap.get(facing1);
                if (handler == null) continue;
                int slots = 0;
                if (handler.getInventory() != null && handler.getInventory() instanceof BlockEntityInventory) {
                    BlockEntityInventory inventory = (BlockEntityInventory)handler.getInventory();
                    for (InventoryOutput slot : this.slots) {
                        for (Inventory invSlot : inventory.getInputSlots()) {
                            ItemStack input;
                            if (invSlot.acceptAllOrIndex()) {
                                for (int j = 0; j < slot.size(); ++j) {
                                    ItemStack output = slot.get(j);
                                    if (output.isEmpty()) continue;
                                    boolean find = false;
                                    if (!itemStackList.isEmpty()) {
                                        for (ItemStack stack : itemStackList) {
                                            if (!stack.is(output.getItem())) continue;
                                            find = true;
                                            break;
                                        }
                                        if (!find) continue;
                                    }
                                    if (!invSlot.canPlaceItem(0, output)) continue;
                                    for (int jj = 0; jj < invSlot.size() && !output.isEmpty(); ++jj) {
                                        int maxCount;
                                        input = invSlot.get(jj);
                                        if (input.isEmpty()) {
                                            if (!invSlot.add(output)) continue;
                                            slot.set(j, ItemStack.EMPTY);
                                            output = ItemStack.EMPTY;
                                            continue;
                                        }
                                        if (!output.is(input.getItem()) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                        input.grow(maxCount);
                                        output.shrink(maxCount);
                                    }
                                }
                                continue;
                            }
                            block24: for (int jj = 0; jj < slot.size(); ++jj) {
                                ItemStack output;
                                for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).isEmpty(); ++j) {
                                    int maxCount;
                                    boolean find = false;
                                    if (!itemStackList.isEmpty()) {
                                        input = itemStackList.iterator();
                                        while (input.hasNext()) {
                                            ItemStack stack = (ItemStack)input.next();
                                            if (!stack.is(output.getItem())) continue;
                                            find = true;
                                            break;
                                        }
                                        if (!find) continue block24;
                                    }
                                    if ((input = invSlot.get(j)).isEmpty()) {
                                        if (!invSlot.canPlaceItem(j, output) || !invSlot.add(output)) continue;
                                        slot.set(jj, ItemStack.EMPTY);
                                        output = ItemStack.EMPTY;
                                        continue;
                                    }
                                    if (!output.is(input.getItem()) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                    input.grow(maxCount);
                                    output.shrink(maxCount);
                                }
                            }
                        }
                    }
                    continue;
                }
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (handler.getInventory() != null) {
                    for (InventoryOutput slot : this.slots) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack stack;
                            took = slot.get(j);
                            if (took.isEmpty()) continue;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack3 : itemStackList) {
                                    if (!stack3.is(took.getItem())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue;
                            }
                            if ((stack = this.insertItem1(handler, took, true, slots)).isEmpty()) {
                                slot.set(j, ItemStack.EMPTY);
                                this.insertItem1(handler, took, false, slots);
                                continue;
                            }
                            if (stack == took) continue;
                            int count = slot.get(j).getCount() - stack.getCount();
                            slot.get(j).shrink(count);
                            stack.setCount(count);
                            this.insertItem1(handler, stack, false, slots);
                        }
                    }
                    continue;
                }
                for (InventoryOutput slot : this.slots) {
                    for (int j = 0; j < slot.size(); ++j) {
                        took = slot.get(j);
                        if (took.isEmpty()) continue;
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack : itemStackList) {
                                if (!stack.is(took.getItem())) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        took = took.copy();
                        ItemStack stack = ModUtils.insertItem(handler.getHandler(), took, true, slots);
                        if (stack.isEmpty()) {
                            slot.set(j, ItemStack.EMPTY);
                            ModUtils.insertItem(handler.getHandler(), took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        slot.get(j).shrink(stack.getCount());
                        ModUtils.insertItem(handler.getHandler(), stack, false, slots);
                    }
                }
            }
        }
    }

    private void tick_fluid(int i) {
        Direction facing = this.facings[i];
        List<Fluid> itemStackList = this.whiteList1.get(i);
        if (facing != null) {
            IFluidHandler handler = this.iFluidHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (this.fluids == null) {
                return;
            }
            for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                int amount;
                if (tank.getFluidAmount() <= 0 || !itemStackList.isEmpty() && !itemStackList.contains(tank.getFluid().getFluid()) || (amount = handler.fill(tank.getFluid(), IFluidHandler.FluidAction.SIMULATE)) <= 0 || !tank.canDrain(facing)) continue;
                tank.drain(handler.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            }
        } else {
            for (Direction facing1 : this.enumFacings) {
                IFluidHandler handler = this.iFluidHandlerMap.get(facing1);
                if (handler == null) continue;
                if (this.fluids == null) {
                    return;
                }
                for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                    int amount;
                    if (tank.getFluidAmount() <= 0 || !itemStackList.isEmpty() && !itemStackList.contains(tank.getFluid().getFluid()) || (amount = handler.fill(tank.getFluid(), IFluidHandler.FluidAction.SIMULATE)) <= 0 || !tank.canDrain(facing1)) continue;
                    tank.drain(handler.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    @Nonnull
    public ItemStack insertItem1(HandlerInventory dest, @Nonnull ItemStack stack, boolean simulate, int slot) {
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < slot; ++i) {
            ItemStack stack2 = this.insertItem2(dest, i, stack, simulate);
            if (stack2.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (stack2 == stack) continue;
            return stack2;
        }
        return stack;
    }

    @Nonnull
    public ItemStack insertItem2(HandlerInventory dest1, int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack stackInSlot;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        IItemHandler dest = dest1.getHandler();
        Container inventory = dest1.getInventory();
        int maxSlots = dest.getSlots();
        try {
            stackInSlot = inventory.getItem(slot);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            stackInSlot = dest.getStackInSlot(slot);
        }
        if (!stackInSlot.isEmpty()) {
            int max = stackInSlot.getMaxStackSize();
            int limit = dest.getSlotLimit(slot);
            if (stackInSlot.getCount() >= Math.min(max, limit)) {
                return stack;
            }
            if (simulate && !inventory.canPlaceItem(slot, stack)) {
                return stack;
            }
            if (!this.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            int m = Math.min(max, limit) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    inventory.setItem(slot, copy);
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                inventory.setItem(slot, copy);
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!inventory.canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), dest.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                inventory.setItem(slot, stack.split(m));
            }
            return stack;
        }
        if (!simulate) {
            try {
                inventory.setItem(slot, stack);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                dest.insertItem(slot, stack, false);
            }
        }
        return ItemStack.EMPTY;
    }

    public double getEnergyStorage(int defaultEnergyStorage, int defaultOperationLength, int defaultEnergyDemand) {
        int opLen = this.getOperationLength(defaultOperationLength);
        double energyDemand = this.getEnergyDemand(defaultEnergyDemand);
        return InventoryUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage + (double)opLen * energyDemand, this.energyStorageMultiplier);
    }
}

