/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.IUItem;
import com.denfop.blockentity.base.BlockEntitySintezator;
import com.denfop.blockentity.panels.entity.EnumSolarPanels;
import com.denfop.blockentity.panels.entity.EnumType;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.WirelessConnection;
import com.denfop.inventory.Inventory;
import com.denfop.items.modules.EnumBaseType;
import com.denfop.items.modules.EnumModule;
import com.denfop.items.modules.ItemAdditionModule;
import com.denfop.items.modules.ItemBaseModules;
import com.denfop.items.modules.ItemModuleType;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;

public class InventorySintezator
extends Inventory {
    public final int type;
    public final BlockEntitySintezator tile;

    public InventorySintezator(BlockEntitySintezator base1, String name, int type, int count) {
        super(base1, Inventory.TypeItemSlot.INPUT_OUTPUT, count);
        this.type = type;
        if (type == 0) {
            this.setStackSizeLimit(64);
        } else {
            this.setStackSizeLimit(1);
        }
        this.tile = base1;
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        if (this.type == 0) {
            this.tile.inputslotA.update();
        } else {
            this.update();
        }
        return content;
    }

    private EnumSolarPanels getType(ItemStack itemStack) {
        for (Map.Entry<ItemStack, EnumSolarPanels> entry : IUItem.map3.entrySet()) {
            if (!entry.getKey().is(itemStack.getItem())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void update() {
        if (this.type == 0) {
            double[] tire_massive = new double[9];
            double[] myArray1 = new double[4];
            for (int i = 0; i < this.size(); ++i) {
                int p;
                EnumSolarPanels solar = this.getType(this.get(i));
                if (!this.get(i).isEmpty() && solar != null) {
                    p = Math.min(this.get(i).getCount(), 64);
                    myArray1[0] = myArray1[0] + solar.genday * (double)p;
                    myArray1[1] = myArray1[1] + solar.gennight * (double)p;
                    myArray1[2] = myArray1[2] + solar.maxstorage * (double)p;
                    myArray1[3] = myArray1[3] + solar.producing * (double)p;
                    tire_massive[i] = solar.tier;
                    continue;
                }
                if (this.get(i).isEmpty() || IUItem.panel_list.get(this.get(i).getDescriptionId()) == null) continue;
                p = Math.min(this.get(i).getCount(), 64);
                ItemStack stack = this.get(i);
                List<Object> solar1 = IUItem.panel_list.get(stack.getDescriptionId());
                if (solar1 == null) continue;
                myArray1[0] = myArray1[0] + (Double)solar1.get(0) * (double)p;
                myArray1[1] = myArray1[1] + (Double)solar1.get(1) * (double)p;
                myArray1[2] = myArray1[2] + (Double)solar1.get(2) * (double)p;
                myArray1[3] = myArray1[3] + (Double)solar1.get(3) * (double)p;
                tire_massive[i] = ((Integer)solar1.get(4)).intValue();
            }
            double max = tire_massive[0];
            for (double v : tire_massive) {
                if (!(v > max)) continue;
                max = v;
            }
            this.tile.machineTire = (int)max;
            this.tile.genDay = myArray1[0];
            this.tile.genNight = myArray1[1];
            this.tile.maxStorage = myArray1[2];
            this.tile.production = myArray1[3];
            this.tile.inputslotA.checkmodule();
            int type = this.tile.solartype;
            this.tile.solartype = this.solartype();
            if (type != this.tile.solartype) {
                this.tile.updateTileEntityField();
            }
        } else {
            this.tile.inputslot.update();
        }
    }

    public void wirelessmodule() {
        BlockEntitySintezator tile = (BlockEntitySintezator)this.base;
        tile.wirelessComponent.removeAll();
        tile.wirelessComponent.setUpdate(false);
        for (int i = 0; i < this.size(); ++i) {
            WirelessConnection wirelessConnection;
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemAdditionModule) || IUItem.module7.getMeta(this.get(i)) != 10 || (wirelessConnection = (WirelessConnection)this.get(i).getOrDefault(DataComponentsInit.WIRELESS, (Object)WirelessConnection.EMPTY)) == WirelessConnection.EMPTY) continue;
            int x = wirelessConnection.x();
            int y = wirelessConnection.y();
            int z = wirelessConnection.z();
            if (wirelessConnection.change()) continue;
            tile.wirelessComponent.setUpdate(true);
            BlockPos pos = new BlockPos(x, y, z);
            tile.wirelessComponent.addConnect(pos);
        }
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack itemStack) {
        if (this.type == 0) {
            return this.getType(itemStack) != null || IUItem.panel_list.containsKey(itemStack.getDescriptionId());
        }
        return itemStack.getItem() instanceof ItemBaseModules || itemStack.getItem() instanceof ItemAdditionModule && IUItem.module7.getMeta(itemStack) == 4 || itemStack.getItem() instanceof ItemAdditionModule && IUItem.module7.getMeta(itemStack) == 10 || itemStack.getItem() instanceof ItemAdditionModule && IUItem.module7.getMeta(itemStack) == 1 || itemStack.getItem() instanceof ItemAdditionModule && IUItem.module7.getMeta(itemStack) == 2 || itemStack.getItem() instanceof ItemModuleType;
    }

    public int solartype() {
        BlockEntitySintezator tile = (BlockEntitySintezator)this.base;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        for (int i = 0; i < tile.inputslotA.size(); ++i) {
            if (!this.get(i).isEmpty() && this.get(i).getItem() instanceof ItemModuleType) {
                list1.add(IUItem.module5.getMeta((ItemModuleType)this.get(i).getItem()) + 1);
                continue;
            }
            list1.add(0);
        }
        EnumType type = EnumType.getFromID(ModUtils.slot(list1));
        return tile.setSolarType(type);
    }

    public void checkmodule() {
        int i;
        BlockEntitySintezator tile = (BlockEntitySintezator)this.base;
        double temp_day = tile.genDay;
        double temp_night = tile.genNight;
        double temp_storage = tile.maxStorage;
        double temp_producing = tile.production;
        block6: for (i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemBaseModules) || EnumModule.getFromID(IUItem.basemodules.getMeta(this.get(i))) == null) continue;
            EnumModule module = EnumModule.getFromID(IUItem.basemodules.getMeta(this.get(i)));
            EnumBaseType type = module.type;
            double percent = module.percent;
            switch (type) {
                case DAY: {
                    temp_day += tile.genDay * percent;
                    continue block6;
                }
                case NIGHT: {
                    temp_night += tile.genNight * percent;
                    continue block6;
                }
                case STORAGE: {
                    temp_storage += tile.maxStorage * percent;
                    continue block6;
                }
                case OUTPUT: {
                    temp_producing += tile.production * percent;
                }
            }
        }
        for (i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemAdditionModule)) continue;
            int damage = IUItem.module7.getMeta(this.get(i));
            if (damage == 1) {
                ++tile.machineTire;
            }
            if (damage != 2) continue;
            --tile.machineTire;
        }
        this.wirelessmodule();
        tile.genDay = temp_day;
        tile.genNight = temp_night;
        tile.maxStorage = temp_storage;
        tile.production = temp_producing;
    }
}

