/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.BlockEntityPrivatizer;
import com.denfop.blocks.ISubEnum;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.inventory.Inventory;
import com.denfop.items.modules.ItemAdditionModule;
import com.denfop.items.modules.ItemEntityModule;
import net.minecraft.world.item.ItemStack;

public class InventoryPrivatizer
extends Inventory
implements ITypeSlot {
    private final int type;
    private final BlockEntityPrivatizer tile;
    private int stackSizeLimit = 1;

    public InventoryPrivatizer(BlockEntityInventory base1, int type, int count) {
        super(base1, Inventory.TypeItemSlot.INPUT_OUTPUT, count);
        this.type = type;
        this.tile = (BlockEntityPrivatizer)base1;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        if (this.type == 1) {
            return EnumTypeSlot.PRIVATE;
        }
        return EnumTypeSlot.QUARRY1;
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        if (this.type == 0) {
            this.update();
        }
        return content;
    }

    @Override
    public void update() {
        if (this.type == 0) {
            this.tile.listItems.clear();
            for (int i = 0; i < this.size(); ++i) {
                String name;
                if (this.get(i).isEmpty() || (name = (String)this.get(i).getOrDefault(DataComponentsInit.NAME, (Object)"")).isEmpty() || this.tile.listItems.contains(name)) continue;
                this.tile.listItems.add(name);
            }
        }
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack itemStack) {
        if (this.type == 0) {
            return itemStack.getItem() instanceof ItemEntityModule && ((ISubEnum)((ItemEntityModule)itemStack.getItem()).getElement()).getId() == 0;
        }
        return itemStack.getItem() instanceof ItemAdditionModule && ((ISubEnum)((ItemAdditionModule)itemStack.getItem()).getElement()).getId() == 0;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }
}

