/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.blockentity.hydroturbine.BlockEntityHydroTurbineController;
import com.denfop.blocks.ISubEnum;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemWaterRod;
import com.denfop.items.ItemWaterRotor;
import net.minecraft.world.item.ItemStack;

public class InventoryHydroTurbineRotorBlades
extends Inventory
implements ITypeSlot {
    private final BlockEntityHydroTurbineController windGenerator;

    public InventoryHydroTurbineRotorBlades(BlockEntityHydroTurbineController windGenerator) {
        super(windGenerator, Inventory.TypeItemSlot.INPUT, 1);
        this.setStackSizeLimit(64);
        this.windGenerator = windGenerator;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        return EnumTypeSlot.WATER_ROD_PART;
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        if (this.windGenerator.getRotor() == null) {
            return false;
        }
        if (this.windGenerator.getRotor() != null && stack.getItem() instanceof ItemWaterRod) {
            return ((ItemWaterRod)stack.getItem()).getLevel(this.windGenerator.getRotor().getLevel(), ((ISubEnum)((ItemWaterRod)stack.getItem()).getElement()).getId());
        }
        return false;
    }

    public void consume(int amount) {
        this.consume(amount, false);
    }

    public void work() {
        if (this.get(0).isEmpty()) {
            return;
        }
        ItemStack stack = this.windGenerator.slot.get(0);
        if (this.windGenerator.getRotor() != null && this.get(0).getItem() instanceof ItemWaterRod && ((ItemWaterRod)this.get(0).getItem()).getLevel(this.windGenerator.getRotor().getLevel(), ((ISubEnum)((ItemWaterRod)this.get(0).getItem()).getElement()).getId()) && (double)((ItemWaterRotor)stack.getItem()).getCustomDamage(stack) <= (double)((ItemWaterRotor)stack.getItem()).getMaxCustomDamage(stack) * 0.75) {
            this.windGenerator.slot.damage((int)((double)(-1 * ((ItemWaterRotor)stack.getItem()).getMaxCustomDamage(stack)) * 0.25), 0.0);
            this.get(0).shrink(1);
        }
    }

    public void consume(int amount, boolean simulate) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = this.get(i);
            if (stack.isEmpty() || amount <= 0) continue;
            int currentAmount = Math.min(amount, stack.getCount());
            if (!simulate) {
                stack.shrink(currentAmount);
            }
            if ((amount -= currentAmount) == 0) break;
        }
    }
}

