/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.api.windsystem.WindRotor;
import com.denfop.blockentity.hydroturbine.BlockEntityHydroTurbineController;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemWaterRotor;
import com.denfop.utils.DamageHandler;
import com.denfop.utils.ModUtils;
import net.minecraft.world.item.ItemStack;

public class InventoryHydroTurbineRotor
extends Inventory
implements ITypeSlot {
    private final BlockEntityHydroTurbineController windGenerator;

    public InventoryHydroTurbineRotor(BlockEntityHydroTurbineController windGenerator) {
        super(windGenerator, Inventory.TypeItemSlot.INPUT, 1);
        this.setStackSizeLimit(1);
        this.windGenerator = windGenerator;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.WATER_ROTOR;
    }

    public int damage(int amount, double chance) {
        int damageApplied = 0;
        if (chance > 0.0 && this.windGenerator.getWorld().random.nextInt(101) > (int)(chance * 100.0)) {
            return 0;
        }
        ItemStack stack = this.get(0);
        if (!ModUtils.isEmpty(stack)) {
            DamageHandler.damage(stack, amount, null);
            if ((double)DamageHandler.getDamage(stack) >= (double)DamageHandler.getMaxDamage(stack) * 0.25) {
                this.windGenerator.need_repair = true;
            }
        }
        return damageApplied;
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        return stack.getItem() instanceof ItemWaterRotor && ((WindRotor)stack.getItem()).getLevel() >= 1 && ((WindRotor)stack.getItem()).getLevel() <= 14;
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.windGenerator.change();
        if (!content.isEmpty()) {
            this.windGenerator.energy.getEnergy().setSourceTier(this.windGenerator.getRotor().getSourceTier());
        } else {
            this.windGenerator.energy.getEnergy().setSourceTier(1);
        }
        return content;
    }
}

