/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.IUItem;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.inventory.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryElectrolyzer
extends Inventory
implements ITypeSlot {
    private final int type;
    private int stackSizeLimit;

    public InventoryElectrolyzer(BlockEntityInventory base1, int type) {
        super(base1, Inventory.TypeItemSlot.INPUT, 1);
        this.type = type;
        this.stackSizeLimit = 1;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        if (this.type == 1) {
            return EnumTypeSlot.CATHODE;
        }
        return EnumTypeSlot.ANODE;
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack itemStack) {
        if (this.type == 0) {
            Item item = itemStack.getItem();
            return item.equals(IUItem.anode.getItem()) || item.equals(IUItem.adv_anode.getItem());
        }
        if (this.type == 1) {
            Item item = itemStack.getItem();
            return item.equals(IUItem.cathode.getItem()) || item.equals(IUItem.adv_cathode.getItem());
        }
        return false;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public void consume(int amount) {
        ((ItemStack)this.contents.get(0)).shrink(amount);
    }
}

