/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.inventory.Inventory;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ModUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class InventoryDischarge
extends Inventory {
    public int tier;
    public boolean allowRedstoneDust;

    public InventoryDischarge(CustomWorldContainer base, Inventory.TypeItemSlot typeItemSlot, int tier) {
        this(base, typeItemSlot, tier, false);
    }

    public InventoryDischarge(CustomWorldContainer base, int tier) {
        this(base, Inventory.TypeItemSlot.INPUT, tier);
    }

    public InventoryDischarge(CustomWorldContainer base, Inventory.TypeItemSlot typeItemSlot, int tier, boolean allowRedstoneDust) {
        super(base, typeItemSlot, 1);
        this.tier = tier;
        this.allowRedstoneDust = allowRedstoneDust;
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        if (this.allowRedstoneDust && stack.getItem() == Items.REDSTONE) {
            return true;
        }
        if (stack.getItem() instanceof EnergyItem) {
            return ElectricItem.manager.discharge(stack, 2.147483647E9, this.tier, true, true, true) > 0.0;
        }
        return false;
    }

    public double discharge(double amount, boolean ignoreLimit) {
        if (amount <= 0.0) {
            return 0.0;
        }
        ItemStack stack = this.get(0);
        if (ModUtils.isEmpty(stack)) {
            return 0.0;
        }
        double realAmount = ElectricItem.manager.discharge(stack, amount, this.tier, ignoreLimit, true, false);
        if (realAmount <= 0.0) {
            realAmount = ModUtils.getEnergyValue(stack);
            if (realAmount <= 0.0) {
                return 0.0;
            }
            stack.shrink(1);
            this.set(0, stack);
        }
        return realAmount;
    }

    public double dischargeWithRedstone(double capacity, double amount) {
        ItemStack stack = this.get(0);
        if (stack.isEmpty()) {
            return 0.0;
        }
        double canAdd = capacity * 0.2;
        int size = stack.getCount();
        int needRemove = (int)Math.min(amount / canAdd, (double)size);
        if (needRemove <= 0) {
            return 0.0;
        }
        this.set(0, ModUtils.decSize(stack, needRemove));
        return (double)needRemove * canAdd;
    }

    public void setTier(int tier1) {
        this.tier = tier1;
    }
}

