/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.inventory.Inventory;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ModUtils;
import net.minecraft.world.item.ItemStack;

public class InventoryCharge
extends Inventory {
    public int tier;
    private boolean ignore;

    public InventoryCharge(CustomWorldContainer base1, int tier) {
        super(base1, Inventory.TypeItemSlot.INPUT_OUTPUT, 1);
        this.tier = tier;
        this.ignore = false;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        return stack.getItem() instanceof EnergyItem && ElectricItem.manager.charge(stack, Double.POSITIVE_INFINITY, this.tier, true, true) > 0.0;
    }

    public double charge(double amount) {
        if (amount <= 0.0) {
            return 0.0;
        }
        ItemStack stack = this.get(0);
        return ModUtils.isEmpty(stack) ? 0.0 : ElectricItem.manager.charge(stack, amount, this.tier, this.ignore, false);
    }

    public void setTier(int tier1) {
        this.tier = tier1;
    }
}

