/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Inventory
extends AbstractList<ItemStack>
implements ITypeSlot,
Container {
    public CustomWorldContainer base;
    protected TypeItemSlot typeItemSlot;
    protected NonNullList<ItemStack> contents;
    protected int stackSizeLimit;

    public Inventory(CustomWorldContainer base, TypeItemSlot typeItemSlot, int count) {
        this.contents = NonNullList.withSize((int)count, (Object)ItemStack.EMPTY);
        this.base = base;
        this.typeItemSlot = typeItemSlot;
        this.stackSizeLimit = 64;
        base.addInventorySlot(this);
    }

    public Inventory(int count) {
        this.contents = NonNullList.withSize((int)count, (Object)ItemStack.EMPTY);
        this.base = null;
        this.typeItemSlot = null;
    }

    @Override
    public void clear() {
        this.contents = NonNullList.withSize((int)this.size(), (Object)ItemStack.EMPTY);
        this.stackSizeLimit = 64;
    }

    public boolean acceptAllOrIndex() {
        return true;
    }

    public TypeItemSlot getTypeItemSlot() {
        return this.typeItemSlot;
    }

    public void setTypeItemSlot(TypeItemSlot typeItemSlot) {
        this.typeItemSlot = typeItemSlot;
    }

    public ItemStack getItem(int pSlot) {
        return this.get(pSlot);
    }

    public ItemStack removeItem(int pSlot, int amount) {
        ItemStack stack = this.getItem(pSlot);
        if (ModUtils.isEmpty(stack)) {
            return ModUtils.emptyStack;
        }
        if (amount >= ModUtils.getSize(stack)) {
            this.set(pSlot, ModUtils.emptyStack);
            return stack;
        }
        if (amount != 0) {
            if (amount < 0) {
                int space = Math.min(this.getStackSizeLimit(), stack.getMaxStackSize()) - ModUtils.getSize(stack);
                amount = Math.max(amount, -space);
            }
            this.set(pSlot, ModUtils.decSize(stack, amount));
        }
        ItemStack ret = stack.copy();
        ret = ModUtils.setSize(ret, amount);
        return ret;
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        ItemStack stack = this.get(pSlot);
        this.contents.set(pSlot, (Object)ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int pSlot, ItemStack pStack) {
        this.set(pSlot, pStack);
    }

    public boolean stillValid(Player pPlayer) {
        return true;
    }

    public void clearContent() {
        this.clear();
    }

    public void readFromNbt(HolderLookup.Provider p_332027_, CompoundTag nbt) {
        this.readFromNbt(nbt, p_332027_);
    }

    public void readFromNbt(CompoundTag nbt, HolderLookup.Provider p_332027_) {
        this.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.contents, (HolderLookup.Provider)p_332027_);
        this.setChanged();
    }

    public CompoundTag writeToNbt(HolderLookup.Provider p_332027_, CompoundTag nbt) {
        return this.writeToNbt(nbt, p_332027_);
    }

    public CompoundTag writeToNbt(CompoundTag nbt, HolderLookup.Provider p_332027_) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.contents, (HolderLookup.Provider)p_332027_);
        return nbt;
    }

    @Override
    public boolean add(List<ItemStack> stacks) {
        boolean added = false;
        for (ItemStack stack : stacks) {
            added = added || this.add(stack);
        }
        return added;
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public int addExperimental(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.addExperimental(stack, false);
    }

    public int addExperimental(ItemStack stack, boolean simulate) {
        if (stack != null && !stack.isEmpty()) {
            int count = stack.getCount();
            int minSlot = this.size();
            for (int i = 0; i < this.size(); ++i) {
                ItemStack stack1 = this.get(i);
                if (stack1.isEmpty()) {
                    if (i >= minSlot) continue;
                    minSlot = i;
                    continue;
                }
                if (stack1.getItem() != stack.getItem()) continue;
                if (stack1.getCount() + count <= stack.getMaxStackSize()) {
                    if (stack.getComponents().isEmpty() && stack1.getComponents().isEmpty()) {
                        if (!simulate) {
                            stack1.grow(stack.getCount());
                        }
                        return 0;
                    }
                    if (!ModUtils.checkNbtEquality(stack.getComponents(), this.get(i).getComponents())) continue;
                    if (!simulate) {
                        stack1.grow(count);
                    }
                    return 0;
                }
                int maxFill = stack1.getMaxStackSize() - stack1.getCount();
                if (maxFill == 0) continue;
                maxFill = Math.min(count, maxFill);
                count -= maxFill;
                stack1.grow(maxFill);
            }
            if (count != 0) {
                if (minSlot != this.size()) {
                    if (!simulate) {
                        this.set(minSlot, ModUtils.setSize(stack, count));
                    }
                    return 0;
                }
                return count;
            }
            return count;
        }
        return 0;
    }

    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    public boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).isEmpty()) {
                        if (i >= minSlot) continue;
                        minSlot = i;
                        continue;
                    }
                    if (this.get(i).getItem() != stack.getItem() || this.get(i).getCount() + stack.getCount() > stack.getMaxStackSize()) continue;
                    if (stack.getComponents().isEmpty() && this.get(i).getComponents().isEmpty()) {
                        if (!simulate) {
                            this.get(i).grow(stack.getCount());
                        }
                        return true;
                    }
                    if (!ModUtils.checkNbtEquality(stack.getComponents(), this.get(i).getComponents())) continue;
                    if (!simulate) {
                        this.get(i).grow(stack.getCount());
                    }
                    return true;
                }
                if (minSlot == this.size()) continue;
                if (!simulate) {
                    this.set(minSlot, stack.copy());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack stack : this.contents) {
            if (ModUtils.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack get(int index) {
        return (ItemStack)this.contents.get(index % this.size());
    }

    public int getContainerSize() {
        return this.size();
    }

    public void setChanged() {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public boolean canInput() {
        return this.typeItemSlot == TypeItemSlot.INPUT || this.typeItemSlot == TypeItemSlot.INPUT_OUTPUT;
    }

    public boolean canOutput() {
        return this.typeItemSlot == TypeItemSlot.OUTPUT || this.typeItemSlot == TypeItemSlot.INPUT_OUTPUT;
    }

    public int getMaxStackSize() {
        return this.stackSizeLimit;
    }

    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    @Override
    public ItemStack set(int i, ItemStack empty) {
        this.contents.set(i, (Object)empty);
        this.setChanged();
        return empty;
    }

    public boolean canShift() {
        return true;
    }

    public void update() {
    }

    public void read(Inventory inventory) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, inventory.get(i));
        }
    }

    public boolean hasItemList() {
        return false;
    }

    public List<IInputItemStack> getStacks(int index) {
        return Collections.emptyList();
    }

    public static enum TypeItemSlot {
        INPUT,
        OUTPUT,
        INPUT_OUTPUT,
        NONE;


        public boolean isInput() {
            return this == INPUT || this == INPUT_OUTPUT;
        }

        public boolean isOutput() {
            return this == OUTPUT || this == INPUT_OUTPUT;
        }
    }
}

