/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.worldcollector.aer;

import com.denfop.IUItem;
import com.denfop.blockentity.mechanism.BlockEntityEnchanterBooks;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.worldcollector.aer.AerHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class AerCategory
extends ScreenMain
implements IRecipeCategory<AerHandler> {
    private final IDrawableStatic bg;
    JeiInform jeiInform;
    private int progress = 0;
    private int energy = 0;

    public AerCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((BlockEntityEnchanterBooks)BlockBaseMachine3Entity.enchanter_books.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiaerassembler.png"), 5, 5, 140, 75);
    }

    public RecipeType<AerHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.basemachine2, 1, 34).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(AerHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(51.0f * (float)this.energy / 100.0f, 51.0f);
        int xScale = 34 * this.progress / 100;
        if (xScale > 34) {
            this.progress = 0;
        }
        AerCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 26, 63 - energylevel, 179, 53 - energylevel, 5, energylevel);
        this.drawTexturedModalRect(stack, 61, 29, 177, 60, xScale, 18);
        this.drawSplitString(stack, Localization.translate("iu.need_info") + recipe.getNeed() + Localization.translate("iu.need_info_matter"), 79, 54, 81, ModUtils.convertRGBcolorToInt(0, 0, 0));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AerHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 39, 19).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 105, 30).addItemStack(recipe.getOutput());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiaerassembler.png");
    }
}

