/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.tuner;

import com.denfop.IUItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TunerHandler {
    private static final List<TunerHandler> recipes = new ArrayList<TunerHandler>();
    private final ItemStack output;

    public TunerHandler(ItemStack output) {
        this.output = output;
    }

    public static List<TunerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            TunerHandler.initRecipes();
        }
        return recipes;
    }

    public static TunerHandler addRecipe(ItemStack output) {
        TunerHandler recipe = new TunerHandler(output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static TunerHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (TunerHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        TunerHandler.addRecipe(new ItemStack((ItemLike)IUItem.module7.getStack(10), 1));
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

