/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.pellets;

import com.denfop.blockentity.mechanism.multimechanism.simple.BlockEntityOreWashing;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.blocks.mechanism.BlockMoreMachine3Entity;
import com.denfop.containermenu.ContainerMenuMultiMachine;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.pellets.PelletsHandler;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PelletsCategory
extends ScreenMain
implements IRecipeCategory<PelletsHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;

    public PelletsCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(new ContainerMenuMultiMachine((Player)Minecraft.getInstance().player, (BlockEntityOreWashing)BlockMoreMachine3Entity.orewashing.getDummyTe(), 1, true));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guipallet.png"), 5, 3, 165, 77);
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(JEICompat.getBlockStack(BlockBaseMachine3Entity.pallet_generator).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(PelletsHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        PelletsCategory.bindTexture(this.getTexture());
        for (int x = 30; x <= 68; x += 18) {
            for (int y = 18; y <= 36; y += 18) {
                this.drawTexturedModalRect(stack, 0 + x, 0 + y, 179, 30, 18, 18);
            }
        }
        double num = 20000.0 / Math.ceil(recipe.getInput());
        this.drawSplitString(stack, String.format("%.2f\u2622 -> 50 EF", num), 90, 30, 190, ModUtils.convertRGBcolorToInt(255, 255, 255));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PelletsHandler recipe, IFocusGroup focuses) {
        for (int i = 0; i < recipe.getCol(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 31 + i % 3 * 18, 19 + i / 3 * 18).addItemStack(recipe.getInput2());
        }
    }

    public RecipeType<PelletsHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guipallet.png");
    }
}

