/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.painting;

import com.denfop.IUItem;
import com.denfop.blockentity.mechanism.multimechanism.simple.BlockEntityOreWashing;
import com.denfop.blocks.mechanism.BlockMoreMachine3Entity;
import com.denfop.containermenu.ContainerMenuMultiMachine;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.painting.PaintingHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PaintingCategory
extends ScreenMain
implements IRecipeCategory<PaintingHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;
    private int progress = 0;
    private int energy = 0;

    public PaintingCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(new ContainerMenuMultiMachine((Player)Minecraft.getInstance().player, (BlockEntityOreWashing)BlockMoreMachine3Entity.orewashing.getDummyTe(), 1, true));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)("textures/gui/GUIPainter".toLowerCase() + ".png")), 3, 3, 140, 75);
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.basemachine1, 1, 3).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(PaintingHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        int xScale = (int)((double)(9 * this.progress) / 100.0);
        if (xScale >= 9) {
            this.progress = 0;
        }
        ItemStack stack1 = recipe.getOutput().copy();
        stack1.set(DataComponentsInit.SKIN, (Object)recipe.metadata.getString("mode"));
        this.draw(stack, ModUtils.mode(stack1), 64, 59, 0x404040);
        PaintingCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 76, 35, 179, 34, xScale, 13);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PaintingHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 33).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 48, 33).addItemStack(recipe.getInput1());
        ItemStack stack1 = recipe.getOutput().copy();
        stack1.set(DataComponentsInit.SKIN, (Object)recipe.metadata.getString("mode"));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 33).addItemStack(stack1);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 103, 33).addItemStack(stack1);
    }

    public RecipeType<PaintingHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/GUIPainter.png".toLowerCase());
    }
}

