/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.molecular;

import com.denfop.IUItem;
import com.denfop.blockentity.mechanism.BlockEntityModuleMachine;
import com.denfop.blocks.mechanism.BlockBaseMachineEntity;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.molecular.MolecularTransformerHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MolecularTransformerCategory
extends ScreenMain
implements IRecipeCategory<MolecularTransformerHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;
    private int progress = 0;

    public MolecularTransformerCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((BlockEntityModuleMachine)BlockBaseMachineEntity.modulator.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimoleculartransformernew.png"), 10, 49, 203, 73);
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.blockmolecular).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(MolecularTransformerHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        double xScale = 18.0 * (double)this.progress / 100.0;
        if (xScale > 18.0) {
            this.progress = 0;
        }
        this.bindTexture();
        this.drawTexturedModalRect(stack, 13, 26, 242, 32, 14, (int)xScale);
        int y = 5;
        int x = 49;
        this.drawSplitString(stack, recipe.inputText, x, y, 200 - x, 0xFFFFFF);
        this.drawSplitString(stack, recipe.outputText, x, y += 18, 200 - x, 0xFFFFFF);
        this.draw(stack, recipe.totalEU, x, y += 18, 0xFFFFFF);
    }

    public RecipeType<MolecularTransformerHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MolecularTransformerHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 12, 8).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 12, 48).addItemStack(recipe.getOutput());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimoleculartransformernew.png");
    }
}

