/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.insulator;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class InsulatorHandler {
    private static final List<InsulatorHandler> recipes = new ArrayList<InsulatorHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;

    public InsulatorHandler(ItemStack input, ItemStack output, FluidStack inputFluid, FluidStack outputFluid) {
        this.input = input;
        this.output = output;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
    }

    public static List<InsulatorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            InsulatorHandler.initRecipes();
        }
        return recipes;
    }

    public static InsulatorHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        List<BaseFluidMachineRecipe> list = Recipes.recipes.getRecipeFluid().getRecipeList("insulator");
        List<BaseMachineRecipe> list1 = Recipes.recipes.getRecipeList("insulator");
        for (int i = 0; i < list1.size(); ++i) {
            BaseFluidMachineRecipe baseFluidMachineRecipe = list.get(i);
            BaseMachineRecipe baseMachineRecipe = list1.get(i);
            ItemStack input = baseMachineRecipe.input.getInputs().get(0).getInputs().get(0);
            ItemStack output = baseMachineRecipe.getOutput().items.get(0);
            FluidStack inputFluid = baseFluidMachineRecipe.input.getInputs().get(0);
            FluidStack outputFluid = baseFluidMachineRecipe.input.getInputs().get(1);
            InsulatorHandler.addRecipe(input, output, inputFluid, outputFluid);
        }
    }

    private static InsulatorHandler addRecipe(ItemStack input, ItemStack output, FluidStack inputFluid, FluidStack outputFluid) {
        InsulatorHandler recipe = new InsulatorHandler(input, output, inputFluid, outputFluid);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }
}

