/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.genred;

import com.denfop.blockentity.mechanism.BlockEntityNuclearWasteRecycler;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.genred.GenRedHandler;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class GenRedCategory
extends ScreenMain
implements IRecipeCategory<GenRedHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;

    public GenRedCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((BlockEntityNuclearWasteRecycler)BlockBaseMachine3Entity.nuclear_waste_recycler.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png"), 5, 5, 140, 75);
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(JEICompat.getBlockStack(BlockBaseMachine3Entity.redstone_generator).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(GenRedHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.drawSplitString(stack, Localization.translate("iu.windgenerator1"), 10, 30, 130, 0x404040);
        this.drawSplitString(stack, ModUtils.getString(recipe.getEnergy()), 10, 37, 130, 0x404040);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GenRedHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 95, 30).addItemStack(recipe.getOutput());
    }

    public RecipeType<GenRedHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png");
    }
}

