/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gendiesel;

import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class GenDieselHandler {
    private static final List<GenDieselHandler> recipes = new ArrayList<GenDieselHandler>();
    private final FluidStack input2;
    private final double input;

    public GenDieselHandler(double input, FluidStack input2) {
        this.input = input;
        this.input2 = input2;
    }

    public static List<GenDieselHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GenDieselHandler.initRecipes();
        }
        return recipes;
    }

    public static GenDieselHandler addRecipe(double input, FluidStack input2) {
        GenDieselHandler recipe = new GenDieselHandler(input, input2);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static GenDieselHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        Iterator<GenDieselHandler> iterator = recipes.iterator();
        if (iterator.hasNext()) {
            GenDieselHandler recipe = iterator.next();
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        GenDieselHandler.addRecipe(100000.0, new FluidStack((Fluid)FluidName.fluiddiesel.getInstance().get(), 1000));
        GenDieselHandler.addRecipe(200000.0, new FluidStack((Fluid)FluidName.fluida_diesel.getInstance().get(), 1000));
        GenDieselHandler.addRecipe(400000.0, new FluidStack((Fluid)FluidName.fluidaa_diesel.getInstance().get(), 1000));
        GenDieselHandler.addRecipe(800000.0, new FluidStack((Fluid)FluidName.fluidaaa_diesel.getInstance().get(), 1000));
        GenDieselHandler.addRecipe(1600000.0, new FluidStack((Fluid)FluidName.fluidaaaa_diesel.getInstance().get(), 1000));
    }

    public double getEnergy() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.input2;
    }
}

