/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.genaddstone;

import com.denfop.api.widget.ItemStackWidget;
import com.denfop.blockentity.mechanism.multimechanism.simple.BlockEntityGearMachine;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.blocks.mechanism.BlockMoreMachine3Entity;
import com.denfop.containermenu.ContainerMenuMultiMachine;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.genaddstone.GenAddStoneHandler;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class GenAddStoneCategory
extends ScreenMain
implements IRecipeCategory<GenAddStoneHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;
    private int energy = 0;

    public GenAddStoneCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(new ContainerMenuMultiMachine((Player)Minecraft.getInstance().player, (BlockEntityGearMachine)BlockMoreMachine3Entity.gearing.getDummyTe(), 1, true));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)("textures/gui/GuiGenStone".toLowerCase() + ".png")), 3, 3, 140, 75);
    }

    public RecipeType<GenAddStoneHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(JEICompat.getBlockStack(BlockBaseMachine3Entity.gen_addition_stone).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(GenAddStoneHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        GenAddStoneCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 6, 47 - energylevel, 176, 14 - energylevel, 14, energylevel);
        new ItemStackWidget(this, 61, 25, () -> new ItemStack((ItemLike)Blocks.COBBLESTONE)).drawBackground(stack, 0, 0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GenAddStoneHandler recipes, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 19).addItemStack(recipes.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 47).addItemStack(recipes.getInput1());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 87, 6).addItemStack(recipes.getOutput());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/GuiGenStone.png".toLowerCase());
    }
}

