/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gaswell;

import com.denfop.blockentity.mechanism.BlockEntityOilRefiner;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.blocks.mechanism.BlockRefinerEntity;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.gaswell.GasPumpHandler;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class GasPumpCategory
extends ScreenMain
implements IRecipeCategory<GasPumpHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;

    public GasPumpCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((BlockEntityOilRefiner)BlockRefinerEntity.refiner.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)("textures/gui/NeutronGeneratorGUI".toLowerCase() + ".png")), 5, 5, 140, 75);
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(JEICompat.getBlockStack(BlockBaseMachine3Entity.gas_pump).getDescriptionId());
    }

    public RecipeType<GasPumpHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(GasPumpHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.drawSplitString(stack, Localization.translate("iu.gaspump.info"), 10, 5, 130, 0x404040);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GasPumpHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 21).setFluidRenderer(10000L, true, 12, 47).addFluidStack(recipe.getOutput().getFluid(), (long)recipe.getOutput().getAmount());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/NeutronGeneratorGUI.png".toLowerCase());
    }
}

