/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.fquarry;

import com.denfop.IUCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class FQuarryHandler {
    private static final List<FQuarryHandler> recipes = new ArrayList<FQuarryHandler>();
    private final ItemStack output;

    public FQuarryHandler(ItemStack output) {
        this.output = output;
    }

    public static List<FQuarryHandler> getRecipes() {
        if (recipes.isEmpty()) {
            FQuarryHandler.initRecipes();
        }
        return recipes;
    }

    public static FQuarryHandler addRecipe(ItemStack output) {
        FQuarryHandler recipe = new FQuarryHandler(output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static FQuarryHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (FQuarryHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (ItemStack container : IUCore.get_ingot) {
            FQuarryHandler.addRecipe(container);
        }
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return is.getItem() == this.output.getItem();
    }
}

