/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.electrolyzer;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class ElectrolyzerHandler {
    private static final List<ElectrolyzerHandler> recipes = new ArrayList<ElectrolyzerHandler>();
    private final FluidStack output1;
    private final FluidStack input;
    private final FluidStack output;

    public ElectrolyzerHandler(FluidStack input, FluidStack output, FluidStack output1) {
        this.input = input;
        this.output1 = output1;
        this.output = output;
    }

    public static List<ElectrolyzerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ElectrolyzerHandler.initRecipes();
        }
        return recipes;
    }

    public static ElectrolyzerHandler addRecipe(FluidStack input, FluidStack output, FluidStack output1) {
        ElectrolyzerHandler recipe = new ElectrolyzerHandler(input, output, output1);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ElectrolyzerHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe machineRecipe : Recipes.recipes.getRecipeFluid().getRecipeList("electrolyzer")) {
            FluidStack fluidStack = machineRecipe.getInput().getInputs().get(0);
            FluidStack fluidStack1 = machineRecipe.getOutput_fluid().get(0);
            FluidStack fluidStack2 = machineRecipe.getOutput_fluid().get(1);
            double m = 1000.0 / (double)fluidStack.getAmount();
            ElectrolyzerHandler.addRecipe(new FluidStack(fluidStack.getFluid(), (int)(m * (double)fluidStack.getAmount())), new FluidStack(fluidStack1.getFluid(), (int)(m * (double)fluidStack1.getAmount())), new FluidStack(fluidStack2.getFluid(), (int)(m * (double)fluidStack2.getAmount())));
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getOutput1() {
        return this.output1;
    }
}

