/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.dryer;

import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.BlockEntityElectricDryer;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.blocks.mechanism.BlockDryerEntity;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentRenderInventory;
import com.denfop.componets.EnumTypeComponentSlot;
import com.denfop.containermenu.ContainerMenuDryer;
import com.denfop.containermenu.SlotInvSlot;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.dryer.DryerHandler;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

public class DryerCategory
extends ScreenMain
implements IRecipeCategory<DryerHandler> {
    private final IDrawableStatic bg;
    private final ContainerMenuDryer container1;
    private final ScreenWidget progress_bar;
    private final JeiInform jeiInform;
    private int progress = 0;
    private int energy = 0;

    public DryerCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((BlockEntityElectricDryer)BlockBaseMachine3Entity.electric_dryer.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png"), 3, 3, 140, 77);
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.slots = new ScreenWidget(this, 3, 3, this.getComponent(), new WidgetDefault<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS__JEI)));
        this.componentList.clear();
        this.container1 = (ContainerMenuDryer)((Object)this.getContainer());
        this.progress_bar = new ScreenWidget(this, 70, 35, EnumTypeComponent.PROCESS, new WidgetDefault<ComponentProgress>(new ComponentProgress((BlockEntityInventory)this.container1.base, 1, 100)));
        this.componentList.add(this.slots);
        this.componentList.add(this.progress_bar);
        this.addWidget(TankWidget.createNormal(this, 43, 21, (IFluidTank)((BlockEntityElectricDryer)BlockBaseMachine3Entity.electric_dryer.getDummyTe()).fluidTank1));
    }

    public RecipeType<DryerHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(JEICompat.getBlockStack(BlockDryerEntity.dryer).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(DryerHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        if (this.energy < 100) {
            ++this.energy;
        }
        double energylevel = (double)this.energy / 100.0;
        double xScale = (double)this.progress / 100.0;
        if (xScale >= 1.0) {
            this.progress = 0;
        }
        DryerCategory.bindTexture(this.getTexture());
        this.slots.drawBackground(stack, 65, -65);
        this.progress_bar.renderBar(stack, 0, 0, xScale);
        for (ScreenWidget element : this.elements) {
            element.drawBackground(stack, this.guiLeft, this.guiTop);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DryerHandler recipes, IFocusGroup focuses) {
        List<SlotInvSlot> slots1 = this.container1.findClassSlots(InventoryOutput.class);
        List<FluidStack> inputs = Collections.singletonList(recipes.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, slots1.get(0).getJeiX() + 65, slots1.get(0).getJeiY() - 65).addItemStack(recipes.getOutput());
        builder.addSlot(RecipeIngredientRole.INPUT, 47, 25).setFluidRenderer(1000L, true, 12, 47).addFluidStack(inputs.get(0).getFluid(), (long)inputs.get(0).getAmount());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png");
    }
}

