/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.deposits;

import com.denfop.blockentity.mechanism.BlockEntityLaserPolisher;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.deposits.DepositsHandler;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.world.vein.VeinType;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DepositsCategory
extends ScreenMain
implements IRecipeCategory<DepositsHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;

    public DepositsCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((BlockEntityLaserPolisher)BlockBaseMachine3Entity.laser_polisher.getDummyTe()).getGuiContainer1((Player)Minecraft.getInstance().player));
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/common3.png"), 3, 3, 200, 180);
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate("deposists.jei");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(DepositsHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        VeinType vein = recipe.getVeinType();
        int y = 20;
        int x = 25;
        this.drawSplitString(stack, Localization.translate("deposists.jei1") + (vein.getHeavyOre() != null ? new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1).getDisplayName().getString() : new ItemStack((ItemLike)vein.getOres().get(0).getBlock().getBlock(), 1).getDisplayName().getString()), 5, 3, 195, 0x404040);
        if (vein.getHeavyOre() != null) {
            this.drawSplitString(stack, " 50%", x, y, 200 - x, 0x404040);
            for (int i = 0; i < vein.getOres().size(); ++i) {
                this.drawSplitString(stack, " " + vein.getOres().get(i).getChance() + "%", x, y + 19 + 20 * i, 200 - x, 0x404040);
            }
        } else {
            for (int i = 0; i < vein.getOres().size(); ++i) {
                this.drawSplitString(stack, " " + vein.getOres().get(i).getChance() + "%", x, y + 20 * i, 200 - x, 0x404040);
            }
        }
    }

    public RecipeType<DepositsHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DepositsHandler recipes, IFocusGroup focuses) {
        List<ItemStack> stackList = recipes.getInputs();
        for (int i = 0; i < stackList.size(); ++i) {
            int x = 5 + i / 8 * 40;
            int y = 15 + i % 8 * 20;
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(stackList.get(i));
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guivein.png");
    }
}

