/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.crops;

import com.denfop.IUItem;
import com.denfop.api.crop.CropNetwork;
import com.denfop.api.crop.ICrop;
import com.denfop.datacomponent.DataComponentsInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CropCrossoverHandler {
    private static final List<CropCrossoverHandler> recipes = new ArrayList<CropCrossoverHandler>();
    public final ICrop output;
    public final List<ICrop> inputs;

    public CropCrossoverHandler(ICrop output, List<ICrop> inputs) {
        this.output = output;
        this.inputs = inputs;
    }

    public static List<CropCrossoverHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CropCrossoverHandler.initRecipes();
        }
        return recipes;
    }

    public static CropCrossoverHandler addRecipe(ICrop output, List<ICrop> inputs) {
        CropCrossoverHandler recipe = new CropCrossoverHandler(output, inputs);
        recipes.add(recipe);
        return recipe;
    }

    public static CropCrossoverHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        CropNetwork.instance.getCropMap().forEach((integer, crop) -> {
            if (crop.isCombine() && !crop.getCropCombine().isEmpty()) {
                CropCrossoverHandler.addRecipe(crop, crop.getCropCombine());
            }
        });
    }

    public ItemStack getOutputs() {
        ItemStack stack = new ItemStack((ItemLike)IUItem.crops.getStack(0));
        stack.set(DataComponentsInit.CROP, (Object)this.output.getId());
        return stack;
    }

    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        this.inputs.forEach(crop -> {
            ItemStack stack = new ItemStack((ItemLike)IUItem.crops.getStack(0));
            stack.set(DataComponentsInit.CROP, (Object)crop.getId());
            itemStackList.add(stack);
        });
        return itemStackList;
    }
}

