/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.alkalineearthquarry;

import com.denfop.IUItem;
import com.denfop.recipes.ItemStackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class AlkalineEarthQuarryHandler {
    private static final List<AlkalineEarthQuarryHandler> recipes = new ArrayList<AlkalineEarthQuarryHandler>();
    public final double chance;
    private final ItemStack input;
    private final ItemStack output;
    private final ItemStack mesh;

    public AlkalineEarthQuarryHandler(ItemStack input, double chance, ItemStack output, ItemStack mesh) {
        this.input = input;
        this.chance = chance;
        this.output = output;
        this.mesh = mesh;
    }

    public static List<AlkalineEarthQuarryHandler> getRecipes() {
        if (recipes.isEmpty()) {
            AlkalineEarthQuarryHandler.initRecipes();
        }
        return recipes;
    }

    public static AlkalineEarthQuarryHandler addRecipe(ItemStack input, double chance, ItemStack output, ItemStack mesh) {
        AlkalineEarthQuarryHandler recipe = new AlkalineEarthQuarryHandler(input, chance, output, mesh);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.SAND), 2.0, ItemStackHelper.fromData(IUItem.ore2, 1, 0), ItemStackHelper.fromData(IUItem.ironMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.SAND), 5.0, ItemStackHelper.fromData(IUItem.ore2, 1, 0), ItemStackHelper.fromData(IUItem.steelMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.SAND), 10.0, ItemStackHelper.fromData(IUItem.ore2, 1, 0), ItemStackHelper.fromData(IUItem.boridehafniumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.SAND), 15.0, ItemStackHelper.fromData(IUItem.ore2, 1, 0), ItemStackHelper.fromData(IUItem.vanadiumaluminumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.SAND), 20.0, ItemStackHelper.fromData(IUItem.ore2, 1, 0), ItemStackHelper.fromData(IUItem.steleticMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.DIRT), 2.0, ItemStackHelper.fromData(IUItem.ore2, 1, 1), ItemStackHelper.fromData(IUItem.steelMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.DIRT), 5.0, ItemStackHelper.fromData(IUItem.ore2, 1, 1), ItemStackHelper.fromData(IUItem.boridehafniumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.DIRT), 10.0, ItemStackHelper.fromData(IUItem.ore2, 1, 1), ItemStackHelper.fromData(IUItem.vanadiumaluminumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.DIRT), 15.0, ItemStackHelper.fromData(IUItem.ore2, 1, 1), ItemStackHelper.fromData(IUItem.steleticMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.GRAVEL), 1.0, ItemStackHelper.fromData(IUItem.ore2, 1, 2), ItemStackHelper.fromData(IUItem.steelMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.GRAVEL), 3.0, ItemStackHelper.fromData(IUItem.ore2, 1, 2), ItemStackHelper.fromData(IUItem.boridehafniumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.GRAVEL), 7.0, ItemStackHelper.fromData(IUItem.ore2, 1, 2), ItemStackHelper.fromData(IUItem.vanadiumaluminumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.GRAVEL), 11.0, ItemStackHelper.fromData(IUItem.ore2, 1, 2), ItemStackHelper.fromData(IUItem.steleticMesh));
    }

    public double getChance() {
        return this.chance;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getMesh() {
        return this.mesh;
    }
}

