/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jade;

import com.denfop.IUItem;
import com.denfop.api.bee.Bee;
import com.denfop.api.crop.ICrop;
import com.denfop.api.energy.interfaces.EnergyConductor;
import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.energy.networking.NodeStats;
import com.denfop.api.otherenergies.common.EnergyBase;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.otherenergies.common.IConductor;
import com.denfop.api.otherenergies.common.ITile;
import com.denfop.api.otherenergies.cool.ICoolSource;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.blockentity.base.BlockEntityAnvil;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.BlockEntityStrongAnvil;
import com.denfop.blockentity.base.IManufacturerBlock;
import com.denfop.blockentity.bee.BlockEntityApiary;
import com.denfop.blockentity.crop.TileEntityCrop;
import com.denfop.blockentity.mechanism.BlockEntityCompressor;
import com.denfop.blockentity.mechanism.BlockEntityDryer;
import com.denfop.blockentity.mechanism.BlockEntityMacerator;
import com.denfop.blockentity.mechanism.BlockEntityPrimalLaserPolisher;
import com.denfop.blockentity.mechanism.BlockEntityPrimalWireInsulator;
import com.denfop.blockentity.mechanism.BlockEntityRollingMachine;
import com.denfop.blockentity.mechanism.BlockEntitySqueezer;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.ProcessMultiComponent;
import com.denfop.integration.jade.Progress;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;

public class BlockComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final BlockComponentProvider INSTANCE = new BlockComponentProvider();

    public ResourceLocation getUid() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"component_provider_blockentity");
    }

    public boolean isRequired() {
        return true;
    }

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        IElementHelper elements = IElementHelper.get();
        CompoundTag data = blockAccessor.getServerData();
        if (data.contains("info")) {
            ListTag listTag = data.getList("info", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.getCompound(i);
                this.writeData(compoundTag, iTooltip, blockAccessor, iPluginConfig, elements);
            }
        }
    }

    private void writeData(CompoundTag compoundTag, ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig, IElementHelper elements) {
        Object o = this.decode(blockAccessor.getLevel().registryAccess(), compoundTag);
        if (o instanceof String) {
            iTooltip.add((IElement)elements.text((Component)Component.literal((String)((String)o))));
        } else if (o instanceof Double) {
            iTooltip.add((IElement)elements.text((Component)Component.literal((String)String.valueOf((Double)o))));
        } else if (o instanceof Integer) {
            iTooltip.add((IElement)elements.text((Component)Component.literal((String)String.valueOf((Integer)o))));
        } else if (o instanceof Progress) {
            Progress progressType = (Progress)o;
            float progress = (float)progressType.getProgress() * 1.0f / (float)progressType.getMax();
            MutableComponent label = Component.literal((String)(progressType.getPrefix() + String.valueOf(ChatFormatting.WHITE) + progressType.getProgress() + " " + progressType.getSuffix()));
            IElementHelper helper = IElementHelper.get();
            ProgressStyle style = helper.progressStyle().color(ModUtils.convertRGBAcolorToInt(progressType.getR(), progressType.getG(), progressType.getB()), ModUtils.convertRGBAcolorToInt(progressType.getR(), progressType.getG(), progressType.getB()));
            iTooltip.add(elements.progress(progress, (Component)label, style, BoxStyle.getNestedBox(), false));
        } else if (o instanceof ItemStack) {
            iTooltip.add(elements.item((ItemStack)o));
        }
    }

    public Object decode(RegistryAccess registryAccess, CompoundTag compoundTag) {
        byte type = compoundTag.getByte("type_field");
        switch (type) {
            case 0: {
                return compoundTag.getString("value_field");
            }
            case 1: {
                return compoundTag.getInt("value_field");
            }
            case 2: {
                return compoundTag.getDouble("value_field");
            }
            case 3: {
                return ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)compoundTag.getCompound("value_field"));
            }
            case 4: {
                return compoundTag.getShort("value_field");
            }
            case 5: {
                int progress = compoundTag.getInt("value_field");
                int max = compoundTag.getInt("value_field1");
                String suffix = compoundTag.getString("value_field2");
                int r = compoundTag.getInt("value_field3");
                int g = compoundTag.getInt("value_field4");
                int b = compoundTag.getInt("value_field5");
                String prefix = compoundTag.getString("value_field7");
                return new Progress(progress, max, suffix, r, g, b, prefix);
            }
        }
        return null;
    }

    public void encode(RegistryAccess registryAccess, Object o, ListTag listTag) {
        CompoundTag compoundTag = new CompoundTag();
        if (o instanceof String) {
            compoundTag.putByte("type_field", (byte)0);
            compoundTag.putString("value_field", (String)o);
        } else if (o instanceof Integer) {
            compoundTag.putByte("type_field", (byte)1);
            compoundTag.putInt("value_field", ((Integer)o).intValue());
        } else if (o instanceof Double) {
            compoundTag.putByte("type_field", (byte)2);
            compoundTag.putDouble("value_field", ((Double)o).doubleValue());
        } else if (o instanceof ItemStack) {
            compoundTag.putByte("type_field", (byte)3);
            compoundTag.put("value_field", ((ItemStack)o).save((HolderLookup.Provider)registryAccess, (Tag)new CompoundTag()));
        } else if (o instanceof Short) {
            compoundTag.putByte("type_field", (byte)4);
            compoundTag.putShort("value_field", ((Short)o).shortValue());
        } else if (o instanceof Progress) {
            compoundTag.putByte("type_field", (byte)5);
            Progress progress = (Progress)o;
            compoundTag.putInt("value_field", progress.getProgress());
            compoundTag.putInt("value_field1", progress.getMax());
            compoundTag.putString("value_field2", progress.getSuffix());
            compoundTag.putInt("value_field3", progress.getR());
            compoundTag.putInt("value_field4", progress.getG());
            compoundTag.putInt("value_field5", progress.getB());
            compoundTag.putString("value_field7", progress.getPrefix());
        }
        listTag.add((Object)compoundTag);
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
        Level level = accessor.getLevel();
        BlockEntity blockEntity = accessor.getBlockEntity();
        Player entityPlayer = accessor.getPlayer();
        if (blockEntity instanceof BlockEntityBase) {
            BlockEntityApiary apiary;
            TileEntityCrop tileEntityCrop;
            Double percent;
            BlockEntityInventory anvil;
            ListTag listTag = new ListTag();
            BlockEntityBase te = (BlockEntityBase)blockEntity;
            if (te.wrenchCanRemove(entityPlayer)) {
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.WHITE) + Localization.translate("iu.wrench.info"), listTag);
            }
            ComponentProgress component = te.getComp(ComponentProgress.class);
            ComponentProcess component1 = te.getComp(ComponentProcess.class);
            ProcessMultiComponent component2 = te.getComp(ProcessMultiComponent.class);
            if (te instanceof BlockEntityAnvil) {
                BlockEntityAnvil anvil2 = (BlockEntityAnvil)te;
                Double percent2 = anvil2.data.getOrDefault(entityPlayer.getUUID(), 0.0);
                String percentString = String.format("%.1f", percent2);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.primitive_master") + " " + (String)percentString, listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GRAY) + Localization.translate("iu.primitive_anvil_durability") + " " + anvil2.durability, listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(anvil2.progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            Level world = level;
            if (te instanceof EnergyConductor) {
                NodeStats node = EnergyNetGlobal.instance.getNodeStats((EnergyTile)((Object)te), level);
                this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)((EnergyConductor)((Object)te)).getConductorBreakdownEnergy(), "EF", 33, 91, 199), listTag);
            }
            if (te instanceof IConductor) {
                IConductor conductor = (IConductor)((Object)te);
                if (conductor.hasEnergies()) {
                    for (EnergyType type : conductor.getEnergies()) {
                        NodeStats node = EnergyBase.getGlobal(type).getNodeStats((ITile)((Object)te), world);
                        if (node == null) continue;
                        if (type == EnergyType.QUANTUM) {
                            this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "QE", 91, 94, 98), listTag);
                            continue;
                        }
                        if (type == EnergyType.SOLARIUM) {
                            this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "SE", 224, 212, 18), listTag);
                            continue;
                        }
                        if (type == EnergyType.EXPERIENCE) {
                            this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "EE", 76, 172, 32), listTag);
                            continue;
                        }
                        if (type == EnergyType.RADIATION) {
                            this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "\u2622", 42, 196, 45), listTag);
                            continue;
                        }
                        if (type != EnergyType.POSITRONS) continue;
                        this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "e\u207a", 192, 0, 218), listTag);
                    }
                } else {
                    EnergyType type = conductor.getEnergyType();
                    NodeStats node = EnergyBase.getGlobal(type).getNodeStats((ITile)((Object)te), world);
                    if (type == EnergyType.QUANTUM) {
                        this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "QE", 91, 94, 98), listTag);
                    } else if (type == EnergyType.SOLARIUM) {
                        this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "SE", 224, 212, 18), listTag);
                    } else if (type == EnergyType.EXPERIENCE) {
                        this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "EE", 76, 172, 32), listTag);
                    } else if (type == EnergyType.RADIATION) {
                        this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "\u2622", 42, 196, 45), listTag);
                    } else if (type == EnergyType.POSITRONS) {
                        this.encode(accessor.getLevel().registryAccess(), new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "e\u207a", 192, 0, 218), listTag);
                    }
                }
            }
            if (te instanceof BlockEntityStrongAnvil) {
                anvil = (BlockEntityStrongAnvil)te;
                percent = anvil.data.getOrDefault(entityPlayer.getUUID(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(anvil.progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof TileEntityCrop && (tileEntityCrop = (TileEntityCrop)te).getCrop() != null) {
                boolean isWeed;
                ItemStack stack;
                ICrop crop = tileEntityCrop.getCrop();
                int tick = crop.getTick();
                int maxTick = crop.getMaxTick();
                this.encode(accessor.getLevel().registryAccess(), new Progress(tick, maxTick, " / " + maxTick + " " + Localization.translate("iu.crop.oneprobe.growth"), -23296), listTag);
                ItemStack soil = crop.getSoil().getStack();
                if (!soil.isEmpty()) {
                    this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.YELLOW) + Localization.translate("iu.crop.oneprobe.soil"), listTag);
                    this.encode(accessor.getLevel().registryAccess(), soil, listTag);
                }
                if (!crop.getDrops().isEmpty() && !(stack = crop.getDrops().get(0)).isEmpty()) {
                    this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.AQUA) + Localization.translate("iu.crop.oneprobe.drop"), listTag);
                    this.encode(accessor.getLevel().registryAccess(), stack, listTag);
                }
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.crop.oneprobe.using") + " " + Localization.translate("iu.crop.oneprobe.fertilizer") + " " + tileEntityCrop.getPestUse() + " / 40", listTag);
                this.encode(accessor.getLevel().registryAccess(), new ItemStack((ItemLike)IUItem.fertilizer.getItem()), listTag);
                int pesticidesTime = tileEntityCrop.getTickPest();
                int maxPesticidesTime = 7000;
                this.encode(accessor.getLevel().registryAccess(), Localization.translate("iu.crop.oneprobe.pesticide_time"), listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(pesticidesTime == 0 ? pesticidesTime : maxPesticidesTime - pesticidesTime, maxPesticidesTime, " / " + maxPesticidesTime + " t", -16711936), listTag);
                int generation = crop.getGeneration();
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.LIGHT_PURPLE) + Localization.translate("iu.crop.oneprobe.generation") + generation, listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.YELLOW) + Localization.translate("iu.crop.oneprobe.genes") + tileEntityCrop.getGenome().getGeneticTraitsMap().values().size(), listTag);
                boolean bl = isWeed = crop.getId() == 3;
                if (isWeed) {
                    this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.RED) + Localization.translate("iu.crop.oneprobe.weed_warning"), listTag);
                }
            }
            if (te instanceof BlockEntityApiary && (apiary = (BlockEntityApiary)te).getQueen() != null) {
                Bee queen = apiary.getQueen();
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.crop.oneprobe.queen") + String.valueOf(ChatFormatting.BOLD) + queen.getName(), listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress((int)apiary.food, apiary.maxFood, " / " + apiary.maxFood + " " + Localization.translate("iu.crop.oneprobe.honey"), -23296), listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress((int)apiary.royalJelly, apiary.maxJelly, " / " + apiary.maxJelly + " " + Localization.translate("iu.crop.oneprobe.royal_jelly"), ModUtils.convertRGBAcolorToInt(146, 146, 146)), listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.crop.oneprobe.workers") + apiary.workers, listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.YELLOW) + Localization.translate("iu.crop.oneprobe.builders") + apiary.builders, listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.RED) + Localization.translate("iu.crop.oneprobe.guards") + apiary.attacks, listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.BLUE) + Localization.translate("iu.crop.oneprobe.medics") + apiary.doctors, listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.DARK_RED) + Localization.translate("iu.crop.oneprobe.sick") + apiary.ill, listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.LIGHT_PURPLE) + Localization.translate("iu.crop.oneprobe.new_bees") + apiary.birthBeeList.size(), listTag);
                String nameMainFlower = Localization.translate("crop." + queen.getCropFlower().getName());
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.AQUA) + Localization.translate("iu.crop.oneprobe.main_flower") + nameMainFlower, listTag);
                InventoryOutput stacks = apiary.invSlotProduct;
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.crop.oneprobe.products"), listTag);
                boolean hasProducts = false;
                for (ItemStack stack : stacks) {
                    if (stack.isEmpty()) continue;
                    this.encode(accessor.getLevel().registryAccess(), stack, listTag);
                    hasProducts = true;
                }
                if (!hasProducts) {
                    this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.DARK_GRAY) + Localization.translate("iu.crop.oneprobe.no_resources"), listTag);
                }
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.crop.oneprobe.frames"), listTag);
                boolean hasFrames = false;
                for (ItemStack stack : apiary.frameSlot) {
                    if (stack.isEmpty()) continue;
                    this.encode(accessor.getLevel().registryAccess(), stack, listTag);
                    hasFrames = true;
                }
                if (!hasFrames) {
                    this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.DARK_GRAY) + Localization.translate("iu.crop.oneprobe.no_frames"), listTag);
                }
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.YELLOW) + Localization.translate("iu.crop.oneprobe.genes_count") + apiary.getGenome().getGeneticTraitsMap().values().size(), listTag);
            }
            if (te instanceof BlockEntityCompressor) {
                anvil = (BlockEntityCompressor)te;
                percent = ((BlockEntityCompressor)anvil).data.getOrDefault(entityPlayer.getUUID(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GRAY) + Localization.translate("iu.primitive_anvil_durability") + " " + ((BlockEntityCompressor)anvil).durability, listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(((BlockEntityCompressor)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof BlockEntityMacerator) {
                anvil = (BlockEntityMacerator)te;
                percent = ((BlockEntityMacerator)anvil).data.getOrDefault(entityPlayer.getUUID(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GRAY) + Localization.translate("iu.primitive_anvil_durability") + " " + ((BlockEntityMacerator)anvil).durability, listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(((BlockEntityMacerator)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof BlockEntityPrimalWireInsulator) {
                anvil = (BlockEntityPrimalWireInsulator)te;
                percent = ((BlockEntityPrimalWireInsulator)anvil).data.getOrDefault(entityPlayer.getUUID(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(((BlockEntityPrimalWireInsulator)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof BlockEntityRollingMachine) {
                anvil = (BlockEntityRollingMachine)te;
                percent = ((BlockEntityRollingMachine)anvil).data.getOrDefault(entityPlayer.getUUID(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(((BlockEntityRollingMachine)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof BlockEntityPrimalLaserPolisher) {
                anvil = (BlockEntityPrimalLaserPolisher)te;
                percent = ((BlockEntityPrimalLaserPolisher)anvil).data.getOrDefault(entityPlayer.getUUID(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(((BlockEntityPrimalLaserPolisher)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof BlockEntitySqueezer) {
                anvil = (BlockEntitySqueezer)te;
                percent = ((BlockEntitySqueezer)anvil).data.getOrDefault(entityPlayer.getUUID(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(((BlockEntitySqueezer)anvil).progress, 150, " / 150", 0x5AFFFF), listTag);
            }
            if (te instanceof BlockEntityDryer) {
                anvil = (BlockEntityDryer)te;
                percent = ((BlockEntityDryer)anvil).data.getOrDefault(entityPlayer.getUUID(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(accessor.getLevel().registryAccess(), new Progress(((BlockEntityDryer)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof IManufacturerBlock) {
                IManufacturerBlock manufacturerBlock = (IManufacturerBlock)((Object)te);
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.WHITE) + Localization.translate("iu.manufacturer_level.info") + manufacturerBlock.getLevelMechanism() + "/10", listTag);
            }
            if (component != null) {
                IUpdateTick updateTick;
                double progress = component.getBar();
                int percentage = (int)(progress * 100.0);
                this.encode(accessor.getLevel().registryAccess(), new Progress(component.getProgress(), component.getMaxValue(), "t", 255, 255, 255), listTag);
                if (component1 != null && (updateTick = (IUpdateTick)((Object)component1.getParent())).getRecipeOutput() != null) {
                    List<IInputItemStack> inputs = updateTick.getRecipeOutput().getRecipe().input.getInputs();
                    List<ItemStack> outputs = updateTick.getRecipeOutput().getRecipe().output.items;
                    if (!inputs.isEmpty()) {
                        this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.YELLOW) + Localization.translate("iu.probe.recipe.input") + " ", listTag);
                        for (IInputItemStack input : inputs) {
                            int index = (int)(level.getGameTime() % (long)input.getInputs().size());
                            this.encode(accessor.getLevel().registryAccess(), input.getInputs().get(index), listTag);
                        }
                    }
                    if (!outputs.isEmpty()) {
                        this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.AQUA) + Localization.translate("iu.probe.recipe.output") + " ", listTag);
                        int index = (int)(level.getGameTime() % (long)outputs.size());
                        this.encode(accessor.getLevel().registryAccess(), outputs.get(index), listTag);
                    }
                }
                this.encode(accessor.getLevel().registryAccess(), String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.probe.recipe.progress") + " " + percentage + "%", listTag);
            }
            if (te instanceof BlockEntityInventory) {
                ArrayList<String> stringList = new ArrayList<String>();
                ((BlockEntityInventory)te).addInformation(((BlockEntityInventory)te).getPickBlock(null, null), stringList);
                for (String s : stringList) {
                    this.encode(accessor.getLevel().registryAccess(), s, listTag);
                }
                for (AbstractComponent comp : te.getComponentList()) {
                    if (comp instanceof Energy) {
                        this.encode(accessor.getLevel().registryAccess(), new Progress((int)((Energy)comp).getEnergy(), (int)((Energy)comp).getCapacity(), "EF", 33, 91, 199), listTag);
                    }
                    if (comp instanceof ComponentBaseEnergy) {
                        ComponentBaseEnergy componentBaseEnergy = (ComponentBaseEnergy)comp;
                        if (componentBaseEnergy.getType() == EnergyType.QUANTUM) {
                            this.encode(accessor.getLevel().registryAccess(), new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "QE", 91, 94, 98), listTag);
                        } else if (componentBaseEnergy.getType() == EnergyType.SOLARIUM) {
                            this.encode(accessor.getLevel().registryAccess(), new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "SE", 224, 212, 18), listTag);
                        } else if (componentBaseEnergy.getType() == EnergyType.EXPERIENCE) {
                            this.encode(accessor.getLevel().registryAccess(), new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "EE", 76, 172, 32), listTag);
                        } else if (componentBaseEnergy.getType() == EnergyType.RADIATION) {
                            this.encode(accessor.getLevel().registryAccess(), new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "\u2622", 42, 196, 45), listTag);
                        } else if (componentBaseEnergy.getType() == EnergyType.POSITRONS) {
                            this.encode(accessor.getLevel().registryAccess(), new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "e\u207a", 192, 0, 218), listTag);
                        }
                    }
                    if (comp instanceof CoolComponent) {
                        CoolComponent coolComponent = (CoolComponent)comp;
                        boolean isRefrigerator = coolComponent.delegate instanceof ICoolSource;
                        if (!coolComponent.upgrade) {
                            if (!isRefrigerator) {
                                this.encode(accessor.getLevel().registryAccess(), new Progress((int)coolComponent.getEnergy(), (int)coolComponent.getCapacity(), "\u00b0C", 190, 23, 20, Localization.translate("iu.temperature")), listTag);
                            } else {
                                this.encode(accessor.getLevel().registryAccess(), new Progress((int)coolComponent.getEnergy(), (int)coolComponent.getCapacity(), "\u00b0C", 33, 98, 208, Localization.translate("iu.temperature") + (coolComponent.getEnergy() > 0.0 ? "-" : "")), listTag);
                            }
                        }
                    }
                    if (!(comp instanceof HeatComponent)) continue;
                    HeatComponent heatComponent = (HeatComponent)comp;
                    this.encode(accessor.getLevel().registryAccess(), new Progress((int)heatComponent.getEnergy(), (int)heatComponent.getCapacity(), "\u00b0C", 208, 61, 33, Localization.translate("iu.temperature")), listTag);
                }
            }
            compoundTag.put("info", (Tag)listTag);
        }
    }
}

