/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events.client;

import com.denfop.api.space.EnumRing;
import com.denfop.api.space.IAsteroid;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.IStar;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.blockentity.mechanism.TileEntityHologramSpace;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class SolarSystemRenderer {
    public static final ResourceLocation SATURN_RING_TEXTURE = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/planet/saturn_ring.png");
    static Map<IBody, Map<IBody, Float[]>> trajectories = new HashMap<IBody, Map<IBody, Float[]>>();
    static Random random = new Random(42L);
    boolean writeData = false;
    IStar star;
    List<IPlanet> planets;
    List<ISatellite> satellites = new ArrayList<ISatellite>();
    private Minecraft minecraft = Minecraft.getInstance();
    private float time;
    private List<IAsteroid> asteroids;

    public static void renderParabolicTrajectory(PoseStack poseStack, RenderLevelStageEvent event, float time, IBody planets, IBody planets1, float progress, ItemStack item) {
        float currentAngle;
        IAsteroid asteroid;
        float x1 = (float)planets.getRotationTimeX(time);
        float z1 = (float)planets.getRotationTimeZ(time);
        float x2 = (float)planets1.getRotationTimeX(time);
        float z2 = (float)planets1.getRotationTimeZ(time);
        if (planets instanceof IAsteroid) {
            asteroid = (IAsteroid)planets;
            currentAngle = asteroid.getMiniAsteroid().get(0).getY() + asteroid.getMiniAsteroid().get(0).getRotationSpeed() * time;
            x1 = asteroid.getMiniAsteroid().get(0).getX() * (float)Math.cos(currentAngle);
            z1 = asteroid.getMiniAsteroid().get(0).getX() * (float)Math.sin(currentAngle);
        }
        if (planets1 instanceof IAsteroid) {
            asteroid = (IAsteroid)planets1;
            currentAngle = asteroid.getMiniAsteroid().get(0).getY() + asteroid.getMiniAsteroid().get(0).getRotationSpeed() * time;
            x2 = asteroid.getMiniAsteroid().get(0).getX() * (float)Math.cos(currentAngle);
            z2 = asteroid.getMiniAsteroid().get(0).getX() * (float)Math.sin(currentAngle);
        }
        float y1 = 0.5f;
        float y2 = 0.5f;
        float centerY = -0.2f;
        int steps = 400;
        float finalX = x1;
        float finalZ = z1;
        float finalX1 = x2;
        float finalZ1 = z2;
        Float[] trajectory = SolarSystemRenderer.calculateTrajectory(finalX, y1, finalZ, finalX1, y2, finalZ1, centerY, steps);
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        Matrix3f matrix3f = poseStack.last().normal();
        VertexConsumer p_109623_ = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tessellator = Tesselator.getInstance();
        RenderSystem.lineWidth((float)2.0f);
        for (int i = 0; i < steps; ++i) {
            float x = trajectory[i * 3].floatValue();
            float y = trajectory[i * 3 + 1].floatValue();
            float z = trajectory[i * 3 + 2].floatValue();
            float color = 0.0f;
            if (progress * (float)steps >= (float)i) {
                color = 1.0f;
            }
            if (color != 0.0f) {
                p_109623_.addVertex(matrix, x, y, z).setColor(0.0f, color, 0.0f, 1.0f).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                continue;
            }
            p_109623_.addVertex(matrix, x, y, z).setColor(0.0f, 0.0f, 0.65f, 1.0f).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
        }
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private static Float[] calculateTrajectory(float x1, float y1, float z1, float x2, float y2, float z2, float centerY, int steps) {
        float centerX = (x1 + x2) / 2.0f;
        float centerZ = (z1 + z2) / 2.0f;
        float a = (centerY - y1) / ((centerX - x1) * (centerX - x1));
        a = Math.max(a, -0.5f);
        Float[] trajectory = new Float[steps * 3];
        for (int i = 0; i < steps; ++i) {
            float t = (float)i / (float)(steps - 1);
            float x = x1 + t * (x2 - x1);
            float z = z1 + t * (z2 - z1);
            float y = a * (x - x1) * (x - x2) + y1;
            trajectory[i * 3] = Float.valueOf(x);
            trajectory[i * 3 + 1] = Float.valueOf(y);
            trajectory[i * 3 + 2] = Float.valueOf(z);
        }
        return trajectory;
    }

    private void renderPlanet(PoseStack poseStack, RenderLevelStageEvent event, float radius, ResourceLocation texture, float x, float y, float z, float rotation, float rotationAngle) {
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotationAngle));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenIndustrialUpgrade.bindTexture(texture);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        this.renderCube(poseStack, buffer, radius);
        poseStack.popPose();
    }

    private void renderRings(PoseStack poseStack, RenderLevelStageEvent event, float radius, ResourceLocation texture, float x, float y, float z, boolean isSaturn) {
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        ScreenIndustrialUpgrade.bindTexture(texture);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_TEX);
        Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f).normalize();
        if (!isSaturn) {
            poseStack.mulPose(new Quaternionf().rotateAxis((float)Math.toRadians(180.0), axis.x(), axis.y(), axis.z()));
            poseStack.scale(0.35f, 0.35f, 0.35f);
        } else {
            poseStack.scale(0.8f, 0.8f, 0.8f);
        }
        this.renderRing(poseStack, buffer, radius);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        poseStack.popPose();
    }

    private void renderCube(PoseStack poseStack, BufferBuilder buffer, float radius) {
        float halfSize = radius / 2.0f;
        Matrix4f matrix = poseStack.last().pose();
        poseStack.pushPose();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        buffer.addVertex(matrix, -halfSize, -halfSize, -halfSize).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, -halfSize, -halfSize).setUv(1.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, halfSize, -halfSize).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, -halfSize, halfSize, -halfSize).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, -halfSize, -halfSize, halfSize).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, -halfSize, halfSize).setUv(1.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, halfSize, halfSize).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, -halfSize, halfSize, halfSize).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, -halfSize, -halfSize, halfSize).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, -halfSize, -halfSize, -halfSize).setUv(1.0f, 0.0f);
        buffer.addVertex(matrix, -halfSize, halfSize, -halfSize).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, -halfSize, halfSize, halfSize).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, halfSize, -halfSize, halfSize).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, -halfSize, -halfSize).setUv(1.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, halfSize, -halfSize).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, halfSize, halfSize, halfSize).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, -halfSize, halfSize, -halfSize).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, halfSize, -halfSize).setUv(1.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, halfSize, halfSize).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, -halfSize, halfSize, halfSize).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, -halfSize, -halfSize, -halfSize).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, -halfSize, -halfSize).setUv(1.0f, 0.0f);
        buffer.addVertex(matrix, halfSize, -halfSize, halfSize).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, -halfSize, -halfSize, halfSize).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private void renderRing(PoseStack poseStack, BufferBuilder buffer, float innerRadius) {
        double outerRadius = (double)innerRadius / 0.9;
        Matrix4f matrix = poseStack.last().pose();
        int segments = 32;
        for (int i = 0; i <= 32; ++i) {
            float theta = (float)((double)i * Math.PI * 2.0 / 32.0);
            float xOuter = (float)(outerRadius * Math.cos(theta));
            float zOuter = (float)(outerRadius * Math.sin(theta));
            buffer.addVertex(matrix, xOuter, 0.0f, zOuter).setUv((float)i / 32.0f, 0.0f);
            float xInner = (float)((double)innerRadius * Math.cos(theta));
            float zInner = (float)((double)innerRadius * Math.sin(theta));
            buffer.addVertex(matrix, xInner, 0.0f, zInner).setUv((float)i / 32.0f, 1.0f);
        }
    }

    public void writeDataInfo() {
        this.star = SpaceInit.solarSystem.getStarList().get(0);
        this.planets = this.star.getPlanetList();
        this.planets.forEach(planets -> this.satellites.addAll(planets.getSatelliteList()));
        this.asteroids = this.star.getAsteroidList();
        this.writeData = true;
        this.time = (float)(75.0 * random.nextDouble());
    }

    public void render(TileEntityHologramSpace te, RenderLevelStageEvent event) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        poseStack.translate((float)te.getPos().getX() + 0.5f, (float)(te.getPos().getY() + 1), (float)te.getPos().getZ() + 0.5f);
        if (!Minecraft.getInstance().isPaused()) {
            this.time += 2.5E-4f;
        }
        poseStack.scale(1.0f, 1.0f, 1.0f);
        if (!this.writeData) {
            this.writeDataInfo();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (IFakeBody fakeBody : te.fakeBodyList) {
            if (fakeBody.getTimerTo().canWork()) {
                SolarSystemRenderer.renderParabolicTrajectory(poseStack, event, this.time, SpaceInit.earth, fakeBody.getBody(), (float)fakeBody.getTimerTo().getProgressBar(), fakeBody.getRover().getItemStack());
                continue;
            }
            SolarSystemRenderer.renderParabolicTrajectory(poseStack, event, this.time, fakeBody.getBody(), SpaceInit.earth, (float)fakeBody.getTimerFrom().getProgressBar(), fakeBody.getRover().getItemStack());
        }
        this.renderPlanet(poseStack, event, (float)this.star.getSize(), this.star.getLocation(), (float)this.star.getRotationTimeX(this.time), 0.5f, (float)this.star.getRotationTimeZ(this.time), (float)this.star.getRotation(this.time), this.star.getRotationAngle());
        this.planets.forEach(planets -> {
            this.renderPlanet(poseStack, event, (float)planets.getSize(), planets.getLocation(), (float)planets.getRotationTimeX(this.time), 0.5f, (float)planets.getRotationTimeZ(this.time), (float)planets.getRotation(this.time), planets.getRotationAngle());
            if (planets.getRing() != null) {
                this.renderRings(poseStack, event, (float)planets.getSize(), SATURN_RING_TEXTURE, (float)planets.getRotationTimeX(this.time), 0.5f, (float)planets.getRotationTimeZ(this.time), planets.getRing() == EnumRing.HORIZONTAL);
            }
        });
        this.satellites.forEach(planets -> this.renderPlanet(poseStack, event, (float)planets.getSize(), planets.getLocation(), (float)planets.getRotationTimeX(this.time), 0.5f, (float)planets.getRotationTimeZ(this.time), (float)planets.getRotation(this.time), planets.getRotationAngle()));
        float deltaTime = this.time;
        this.asteroids.forEach(asteroids -> asteroids.getMiniAsteroid().forEach(miniAsteroid -> {
            float currentAngle = miniAsteroid.getY() + miniAsteroid.getRotationSpeed() * deltaTime;
            float x = miniAsteroid.getX() * (float)Math.cos(currentAngle);
            float z = miniAsteroid.getX() * (float)Math.sin(currentAngle);
            this.renderAsteroid(poseStack, event, miniAsteroid.getSize(), x, 0.5f, z, miniAsteroid.getRotationSpeed(), (IAsteroid)asteroids);
        }));
        poseStack.popPose();
    }

    private void renderAsteroid(PoseStack poseStack, RenderLevelStageEvent event, float size, float x, float y, float z, float rotationSpeed, IAsteroid asteroid) {
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationSpeed));
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        this.renderPlanet(poseStack, event, size, asteroid.getLocation(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
    }
}

