/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events.client;

import com.denfop.mixin.access.LevelRendererAccessor;
import com.denfop.screen.ScreenMain;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class GlobalRenderManager {
    private static final Map<String, Map<BlockPos, Function<RenderLevelStageEvent, Void>>> globalRenders = new HashMap<String, Map<BlockPos, Function<RenderLevelStageEvent, Void>>>();
    public static long tick = 0L;

    public GlobalRenderManager() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public static void addRender(Level world, BlockPos pos, Function<RenderLevelStageEvent, Void> globalRender) {
        String dimension = world.dimension().location().toString();
        globalRenders.computeIfAbsent(dimension, k -> new HashMap()).putIfAbsent(pos, globalRender);
    }

    public static void removeRender(Level world, BlockPos pos) {
        String dimension = world.dimension().location().toString();
        globalRenders.computeIfPresent(dimension, (k, v) -> {
            v.remove(pos);
            return v.isEmpty() ? null : v;
        });
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ((Map)globalRenders.getOrDefault(((Level)event.getLevel()).dimension().toString(), new HashMap())).clear();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onWorldTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide && tick != event.getEntity().level().getGameTime()) {
            tick = event.getEntity().level().getGameTime();
            Screen guiScreen = Minecraft.getInstance().screen;
            if (guiScreen instanceof ScreenMain) {
                for (double ticks = 4.0; ticks > 0.0; ticks -= 1.0) {
                    ((ScreenMain)guiScreen).updateTickInterface();
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.level == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        try {
            for (Map.Entry<String, Map<BlockPos, Function<RenderLevelStageEvent, Void>>> entry : globalRenders.entrySet()) {
                if (!Objects.equals(entry.getKey(), mc.level.dimension().location().toString())) continue;
                PoseStack poseStack = event.getPoseStack();
                Vec3 camera = event.getCamera().getPosition();
                double x = camera.x;
                double y = camera.y;
                double z = camera.z;
                double dopY = 0.0;
                poseStack.pushPose();
                poseStack.translate(-x, -y, -z);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (Function<RenderLevelStageEvent, Void> function : entry.getValue().values()) {
                    function.apply(event);
                }
                ((LevelRendererAccessor)event.getLevelRenderer()).getRenderBuffers().bufferSource().endBatch();
                poseStack.popPose();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

