/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.network.WorldData;
import com.denfop.world.IWorldTickCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class TickHandlerIU {
    public static void requestSingleWorldTick(Level world, IWorldTickCallback callback) {
        WorldData.get((Level)world).singleUpdates.add(callback);
    }

    private static void processUpdates(Level world, WorldData worldData) {
        IWorldTickCallback callback;
        while ((callback = worldData.singleUpdates.poll()) != null) {
            callback.onTick(world);
        }
    }

    @SubscribeEvent
    public void hurt(LivingDamageEvent.Pre event) {
        if (event.getEntity() instanceof LivingEntity && (!event.getEntity().isBlocking() || event.getSource().is(DamageTypeTags.BYPASSES_SHIELD))) {
            NonNullList armorList = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
            armorList.set(0, (Object)event.getEntity().getItemBySlot(EquipmentSlot.FEET));
            armorList.set(1, (Object)event.getEntity().getItemBySlot(EquipmentSlot.LEGS));
            armorList.set(2, (Object)event.getEntity().getItemBySlot(EquipmentSlot.CHEST));
            armorList.set(3, (Object)event.getEntity().getItemBySlot(EquipmentSlot.HEAD));
            float damageAmount = ISpecialArmor.ArmorProperties.applyArmor(event.getEntity(), (NonNullList<ItemStack>)armorList, event.getSource(), event.getOriginalDamage());
            damageAmount = ISpecialArmor.ArmorProperties.applyArmor(event.getEntity(), (NonNullList<ItemStack>)armorList, event.getSource(), damageAmount);
            event.setNewDamage(damageAmount);
        }
    }

    @SubscribeEvent
    public void onWorldTick1(LevelTickEvent.Pre event) {
        Level world = event.getLevel();
        WorldData worldData = WorldData.get(world, false);
        if (worldData != null) {
            TickHandlerIU.processUpdates(world, worldData);
        }
    }

    @SubscribeEvent
    public void onWorldTick(LevelTickEvent.Post event) {
        Level world = event.getLevel();
        WorldData worldData = WorldData.get(world, false);
        if (worldData != null) {
            if (world.isClientSide) {
                IUCore.network.getClient().onTickEnd(worldData);
            } else {
                IUCore.network.getServer().onTickEnd(worldData);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(LevelTickEvent.Pre event) {
        if (!event.getLevel().isClientSide) {
            return;
        }
        IUCore.keyboard.sendKeyUpdate(event.getLevel());
        if (Minecraft.getInstance().level != null) {
            if (IUDamageSource.current == null) {
                IUDamageSource.initDamage(event.getLevel().registryAccess());
            }
            Level world = event.getLevel();
            TickHandlerIU.processUpdates(world, WorldData.get(world));
        }
    }
}

