/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeItemInform;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.pollution.component.ChunkLevel;
import com.denfop.api.pollution.radiation.RadiationSystem;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import com.denfop.api.space.upgrades.info.SpaceUpgradeItemInform;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.lightning_rod.BlockEntityLightningRodController;
import com.denfop.blockentity.lightning_rod.IController;
import com.denfop.blockentity.mechanism.BlockEntityPalletGenerator;
import com.denfop.blockentity.transport.tiles.BlockEntityMultiCable;
import com.denfop.blocks.ISubEnum;
import com.denfop.containermenu.ContainerMenuBags;
import com.denfop.containermenu.ContainerMenuLeadBox;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.ItemBaseCircuit;
import com.denfop.items.ItemCraftingElements;
import com.denfop.items.armour.ItemAdvJetpack;
import com.denfop.items.armour.special.EnumCapability;
import com.denfop.items.armour.special.ItemSpecialArmor;
import com.denfop.items.bags.ItemEnergyBags;
import com.denfop.items.bags.ItemLeadBox;
import com.denfop.items.modules.EnumBaseType;
import com.denfop.items.modules.EnumModule;
import com.denfop.items.modules.ItemAdditionModule;
import com.denfop.items.modules.ItemBaseModules;
import com.denfop.items.modules.ItemCoolingUpgrade;
import com.denfop.items.modules.ItemEntityModule;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.items.resource.ItemNuclearResource;
import com.denfop.network.WorldData;
import com.denfop.network.packet.PacketColorPickerAllLoggIn;
import com.denfop.network.packet.PacketRadiationUpdateValue;
import com.denfop.utils.CapturedMobUtils;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class IUEventHandler {
    public static TagKey<Item> electrumTag = new TagKey(Registries.ITEM, ResourceLocation.tryParse((String)"c:ingots/electrum"));
    public static TagKey<Item> coalDustTag = new TagKey(Registries.ITEM, ResourceLocation.tryParse((String)"c:dusts/coal"));
    public static List<ItemEntity> entityItemList = new LinkedList<ItemEntity>();
    final ChatFormatting[] name = new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.YELLOW, ChatFormatting.BLUE, ChatFormatting.RED, ChatFormatting.GRAY, ChatFormatting.GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.AQUA};
    final String[] mattertype = new String[]{"matter.name", "sun_matter.name", "aqua_matter.name", "nether_matter.name", "night_matter.name", "earth_matter.name", "end_matter.name", "aer_matter.name"};
    BaseMachineRecipe EMPTY = new BaseMachineRecipe(null, null);
    Tuple<ItemStack, BaseMachineRecipe> tupleRecipe = new Tuple((Object)ItemStack.EMPTY, (Object)this.EMPTY);
    Tuple<ItemStack, BaseMachineRecipe> tupleReplicatorRecipe = new Tuple((Object)ItemStack.EMPTY, (Object)this.EMPTY);

    public static boolean getUpgradeItem(ItemStack stack) {
        Item item = stack.getItem();
        return item instanceof UpgradeItem;
    }

    @SubscribeEvent
    public void onWorldTick1(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level.dimension() == Level.OVERWORLD) {
            if (BlockEntityBase.ticker % 120 == 0) {
                BlockEntityBase.ticker = 1;
                BlockEntityBase.updates.clear();
            } else {
                ++BlockEntityBase.ticker;
            }
        }
        if (!level.isThundering() || level.isClientSide || level.getGameTime() % 20L != 0L) {
            return;
        }
        if (WorldBaseGen.random.nextInt(100) < 2) {
            for (Map.Entry<BlockPos, IController> entry : BlockEntityLightningRodController.controllerMap.entrySet()) {
                IController controller = entry.getValue();
                if (!controller.isFull() || controller.getTimer().isCanWork()) continue;
                BlockPos antennaPos = controller.getBlockAntennaPos();
                LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                if (lightning == null) break;
                lightning.moveTo((double)antennaPos.getX(), (double)antennaPos.getY(), (double)antennaPos.getZ());
                level.addFreshEntity((Entity)lightning);
                controller.getTimer().setCanWork(true);
                controller.getTimer().resetTime();
                controller.getEnergy().addEnergy(500000.0);
                break;
            }
        }
    }

    @SubscribeEvent
    public void workCutters(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity tile;
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (world.isClientSide) {
            return;
        }
        if (stack.getItem() == IUItem.cutter.getItem()) {
            BlockEntity tile2 = world.getBlockEntity(pos);
            if (tile2 instanceof BlockEntityMultiCable) {
                BlockEntityMultiCable cable = (BlockEntityMultiCable)tile2;
                ItemStack drop = cable.getPickBlock(player, null);
                if (!drop.isEmpty()) {
                    ModUtils.dropAsEntity(world, pos, drop);
                }
                cable.removeConductor();
            }
        } else if (!stack.isEmpty() && (tile = world.getBlockEntity(pos)) instanceof BlockEntityBase && player.isShiftKeyDown()) {
            ((BlockEntityBase)tile).onSneakingActivated(player, event.getHand(), event.getFace(), event.getHitVec().getLocation());
        }
    }

    @SubscribeEvent
    public void bagPickup(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        try {
            ItemStack stack2;
            Item bags;
            ItemStack stack;
            int i;
            boolean isContainerBox;
            boolean isContainerBags = !(player.containerMenu instanceof ContainerMenuBags);
            boolean bl = isContainerBox = !(player.containerMenu instanceof ContainerMenuLeadBox);
            if (isContainerBags) {
                for (i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    stack = player.getInventory().getItem(i);
                    if (!(stack.getItem() instanceof ItemEnergyBags) || !UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BAGS, stack)) continue;
                    bags = (ItemEnergyBags)stack.getItem();
                    stack2 = event.getItemEntity().getItem();
                    if (event.getItemEntity().isRemoved() || stack2.getItem() instanceof ItemEnergyBags || !bags.canInsert(player, stack, stack2)) continue;
                    ItemStack stack1 = stack2.copy();
                    stack1.setCount(Math.min(stack1.getCount(), stack1.getMaxStackSize()));
                    bags.insert(player, stack, stack1);
                    event.getItemEntity().setItem(stack1);
                    event.getItemEntity().remove(Entity.RemovalReason.KILLED);
                    event.setCanPickup(TriState.FALSE);
                    return;
                }
            }
            if (isContainerBox) {
                for (i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    stack = player.getInventory().getItem(i);
                    if (!(stack.getItem() instanceof ItemLeadBox)) continue;
                    bags = (ItemLeadBox)stack.getItem();
                    stack2 = event.getItemEntity().getItem();
                    if (event.getItemEntity().isRemoved() || stack2.getItem() instanceof ItemLeadBox || !bags.canInsert(player, stack, stack2)) continue;
                    ItemStack stack1 = stack2.copy();
                    stack1.setCount(Math.min(stack1.getCount(), stack1.getMaxStackSize()));
                    bags.insert(player, stack, stack1);
                    event.getItemEntity().setItem(stack1);
                    event.getItemEntity().remove(Entity.RemovalReason.KILLED);
                    event.setCanPickup(TriState.FALSE);
                    return;
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onCropGrowPre(CropGrowEvent.Pre event) {
        BlockPos pos = event.getPos();
        Level world = (Level)event.getLevel();
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkLevel pollution = PollutionManager.pollutionManager.getChunkLevelSoil(chunkPos);
        if (pollution != null) {
            int pollutionLevel = pollution.getLevelPollution().ordinal();
            if (pollutionLevel >= 4) {
                event.setResult(CropGrowEvent.Pre.Result.DO_NOT_GROW);
            } else if (pollutionLevel >= 1) {
                int chance = 0;
                chance = pollutionLevel == 1 ? 25 : (pollutionLevel == 2 ? 50 : 75);
                if (world.random.nextInt(100) < chance) {
                    event.setResult(CropGrowEvent.Pre.Result.DO_NOT_GROW);
                }
            }
        }
    }

    @SubscribeEvent
    public void onCropGrowPre1(CropGrowEvent.Pre event) {
        BlockPos pos = event.getPos().below();
        Level world = (Level)event.getLevel();
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() == IUItem.humus.getBlock(0) && world.random.nextFloat() < 0.5f) {
            event.setResult(CropGrowEvent.Pre.Result.GROW);
        }
    }

    @SubscribeEvent
    public void loginPlayer(PlayerEvent.PlayerLoggedInEvent event) {
        RadiationSystem.rad_system.update(event.getEntity());
        if (event.getEntity().level().isClientSide) {
            return;
        }
        new PacketColorPickerAllLoggIn(event.getEntity());
        new PacketRadiationUpdateValue(event.getEntity(), event.getEntity().getPersistentData().getDouble("radiation"));
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            CompoundTag nbt = player.getPersistentData();
            nbt.putDouble("radiation", 0.0);
        }
    }

    public void setFly(Player player, boolean fly, ItemStack stack) {
        player.getAbilities().flying = fly;
        player.getAbilities().mayfly = fly;
        player.getPersistentData().putBoolean("isFlyActive", fly);
        if (player.level().isClientSide && !fly) {
            player.getAbilities().setFlyingSpeed(0.05f);
            player.fallDistance = 0.0f;
        } else {
            boolean edit = player.getPersistentData().getBoolean("edit_fly");
            if (!edit) {
                int flyspeed;
                int n = flyspeed = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLYSPEED, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.FLYSPEED, (ItemStack)stack).number : 0;
                if (player.level().isClientSide) {
                    player.getAbilities().setFlyingSpeed((float)((double)0.1f + 0.05 * (double)flyspeed));
                }
            } else if (player.level().isClientSide) {
                player.getAbilities().setFlyingSpeed(player.getPersistentData().getFloat("fly_speed"));
            }
        }
    }

    public boolean canFly(ItemStack stack) {
        return stack.getItem() == IUItem.spectral_chestplate.getItem() || stack.getItem() instanceof ItemSpecialArmor && (((ItemSpecialArmor)stack.getItem()).getListCapability().contains((Object)EnumCapability.FLY) || ((ItemSpecialArmor)stack.getItem()).getListCapability().contains((Object)EnumCapability.JETPACK_FLY)) || stack.getItem() instanceof ItemAdvJetpack && UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLY, stack);
    }

    @SubscribeEvent
    public void FlyUpdate(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        CompoundTag nbtData = player.getPersistentData();
        if (!player.isCreative()) {
            if (!((ItemStack)player.getInventory().armor.get(2)).isEmpty()) {
                if (this.canFly((ItemStack)player.getInventory().armor.get(2))) {
                    boolean jetpack = (Boolean)((ItemStack)player.getInventory().armor.get(2)).getOrDefault(DataComponentsInit.JETPACK, (Object)false);
                    if (!jetpack) {
                        if (nbtData.getBoolean("isFlyActive")) {
                            nbtData.putBoolean("hasFly", true);
                            this.setFly(player, false, (ItemStack)player.getInventory().armor.get(2));
                        }
                    } else if (!player.onGround()) {
                        boolean pressed = IUCore.keyboard.isJumpKeyDown(player);
                        if (pressed && !((Boolean)((ItemStack)player.getInventory().armor.get(2)).getOrDefault(DataComponentsInit.FLY, (Object)false)).booleanValue()) {
                            this.setFly(player, true, (ItemStack)player.getInventory().armor.get(2));
                            ((ItemStack)player.getInventory().armor.get(2)).set(DataComponentsInit.FLY, (Object)true);
                            nbtData.putBoolean("canjump", false);
                        }
                    } else if (nbtData.getBoolean("isFlyActive")) {
                        this.setFly(player, false, (ItemStack)player.getInventory().armor.get(2));
                        ((ItemStack)player.getInventory().armor.get(2)).set(DataComponentsInit.FLY, (Object)true);
                    } else if (((Boolean)((ItemStack)player.getInventory().armor.get(2)).getOrDefault(DataComponentsInit.FLY, (Object)false)).booleanValue()) {
                        ((ItemStack)player.getInventory().armor.get(2)).set(DataComponentsInit.FLY, (Object)false);
                    }
                } else if (!((ItemStack)player.getInventory().armor.get(2)).isEmpty() && nbtData.getBoolean("isFlyActive")) {
                    this.setFly(player, false, (ItemStack)player.getInventory().armor.get(2));
                }
            } else if (nbtData.getBoolean("isFlyActive")) {
                this.setFly(player, false, (ItemStack)player.getInventory().armor.get(2));
            }
        } else if (nbtData.getBoolean("isFlyActive")) {
            this.setFly(player, false, (ItemStack)player.getInventory().armor.get(2));
        }
    }

    @SubscribeEvent
    public void onWorldTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide) {
            ServerLevel world = (ServerLevel)event.getLevel();
            if (world.getGameTime() % 20L != 0L) {
                return;
            }
            LevelEntityGetter iterable = world.getEntities();
            List<Entity> list = StreamSupport.stream(iterable.getAll().spliterator(), false).filter(entity -> entity instanceof ItemEntity).toList();
            for (Entity entity2 : list) {
                ItemEntity entityItem;
                ItemEntity itemEntity;
                if (!(entity2 instanceof ItemEntity) || (itemEntity = (ItemEntity)entity2).isRemoved() || !itemEntity.isInWater() || (entityItem = this.checkAndTransform(world, itemEntity)) == null) continue;
                world.addFreshEntity((Entity)entityItem);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        WorldData.onWorldUnload((Level)event.getLevel());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void addInformItem(ItemTooltipEvent event) {
        CapturedMobUtils capturedMobUtils;
        int level;
        Object blockItem;
        BlockState blockState;
        List<Component> list;
        ItemStack stack = event.getItemStack();
        if (event.getItemStack().isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        if (item == IUItem.charged_redstone.getItem()) {
            event.getToolTip().add(Component.literal((String)Localization.translate("charged_redstone.info")));
        }
        if (item == IUItem.recipe_schedule.getItem()) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.receptor.info")));
        }
        if (item == IUItem.connect_item.getItem()) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.configure_cable.info")));
        }
        if (item == IUItem.crafting_elements.getStack(40)) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.dosimeter.info")));
        }
        if (item == IUItem.crafting_elements.getStack(143)) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.schedule_reactor.info")));
        }
        if (item == IUItem.veinsencor.getStack(0)) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.scanner_info")));
        }
        if (item == IUItem.efReader.getItem()) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.ef_meter.info")));
        }
        if (item == IUItem.facadeItem.getItem()) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.facade_item.info")));
        }
        if (item == IUItem.reactorData.getItem()) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.reactor_data.info")));
        }
        if (stack.getItem() instanceof BlockItem && !(list = ModUtils.getInformationFromOre(blockState = (blockItem = (BlockItem)stack.getItem()).getBlock().defaultBlockState())).isEmpty()) {
            event.getToolTip().add(Component.literal((String)Localization.translate("veins_ores.info1")));
            event.getToolTip().add(Component.literal((String)Localization.translate("veins_ores.info")));
            event.getToolTip().addAll(list);
        }
        if (item instanceof IRadioactiveItemType || item instanceof ItemNuclearResource) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.radiation.warning")));
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.radioprotector.info")));
        }
        for (Map.Entry entry : BlockEntityPalletGenerator.integerMap.entrySet()) {
            if (!((ItemStack)entry.getKey()).is(stack.getItem())) continue;
            event.getToolTip().add(Component.literal((String)(Localization.translate("iu.pellets.info") + String.valueOf(entry.getValue()))));
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.pellets.info1")));
        }
        if (item.equals(IUItem.module_quickly.getItem())) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.info.module.speed")));
        }
        if (item.equals(IUItem.module_stack.getItem())) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.info.module.stack")));
        }
        if (item.equals(IUItem.module_storage.getItem())) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.info.module.sorting")));
        }
        if (item instanceof ItemCraftingElements && ((ISubEnum)((ItemCraftingElements)item).getElement()).getId() >= 206 && ((ISubEnum)((ItemCraftingElements)item).getElement()).getId() <= 216) {
            int meta = ((ISubEnum)((ItemCraftingElements)item).getElement()).getId() - 205;
            event.getToolTip().add(Component.literal((String)(Localization.translate("iu.limiter.info9") + EnergyNetGlobal.instance.getPowerFromTier(meta) + " EF")));
        }
        if ((item instanceof ItemBaseCircuit && (((ISubEnum)((ItemBaseCircuit)item).getElement()).getId() == 9 || ((ISubEnum)((ItemBaseCircuit)item).getElement()).getId() == 10 || ((ISubEnum)((ItemBaseCircuit)item).getElement()).getId() == 11 || ((ISubEnum)((ItemBaseCircuit)item).getElement()).getId() == 21) || item instanceof ItemCraftingElements && (((ISubEnum)((ItemCraftingElements)item).getElement()).getId() == 272 || ((ISubEnum)((ItemCraftingElements)item).getElement()).getId() == 273)) && (level = ((Integer)stack.getOrDefault(DataComponentsInit.LEVEL_MICROCHIP, (Object)0)).intValue()) != 0) {
            event.getToolTip().add(Component.literal((String)(Localization.translate("circuit.level") + " " + level)));
        }
        if (item instanceof ItemAdditionModule && ((ISubEnum)((ItemAdditionModule)item).getElement()).getId() == 9) {
            event.getToolTip().add(Component.literal((String)Localization.translate("module.wireless")));
        }
        if (item.equals(IUItem.upgrade_speed_creation.getItem()) || item.equals(IUItem.autoheater.getItem()) || item instanceof ItemCoolingUpgrade || item.equals(IUItem.module_quickly.getItem()) || item.equals(IUItem.module_stack.getItem()) || item.equals(IUItem.module_storage.getItem()) || item instanceof ItemAdditionModule && (((ISubEnum)((ItemAdditionModule)item).getElement()).getId() == 4 || ((ISubEnum)((ItemAdditionModule)item).getElement()).getId() == 10)) {
            event.getToolTip().add(Component.literal((String)Localization.translate("module.wireless")));
        }
        if (item instanceof ItemEntityModule && (capturedMobUtils = CapturedMobUtils.create(stack, event.getEntity().registryAccess())) != CapturedMobUtils.EMPTY) {
            Entity entity = capturedMobUtils.getEntity(player.level(), true);
            event.getToolTip().add(entity.getName());
        }
        if (ListInformationUtils.mechanism_info != null && !ListInformationUtils.mechanism_info.isEmpty() && (item.equals(IUItem.module_quickly.getItem()) || item.equals(IUItem.module_stack.getItem()) || item.equals(IUItem.module_storage.getItem()))) {
            event.getToolTip().add(Component.literal((String)Localization.translate("using_kit")));
            if (!Keyboard.isKeyDown(340)) {
                event.getToolTip().add(Component.literal((String)ListInformationUtils.mechanism_info.get(ListInformationUtils.index)));
            } else {
                for (String string : ListInformationUtils.mechanism_info) {
                    event.getToolTip().add(Component.literal((String)string));
                }
            }
        }
        if (item instanceof ItemCoolingUpgrade) {
            event.getToolTip().add(Component.literal((String)Localization.translate("using_kit")));
            List<String> list3 = ListInformationUtils.integerListMap.get(((ISubEnum)((ItemCoolingUpgrade)item).getElement()).getId());
            if (list3 != null) {
                if (!Keyboard.isKeyDown(340)) {
                    event.getToolTip().add(Component.literal((String)list3.get(ListInformationUtils.index % list3.size())));
                } else {
                    for (String string : list3) {
                        event.getToolTip().add(Component.literal((String)string));
                    }
                }
            }
        }
        if (item.equals(IUItem.autoheater.getItem()) && ListInformationUtils.mechanism_info2.size() > 0) {
            event.getToolTip().add(Component.literal((String)Localization.translate("using_kit")));
            if (!Keyboard.isKeyDown(340)) {
                event.getToolTip().add(Component.literal((String)ListInformationUtils.mechanism_info2.get(ListInformationUtils.index2)));
            } else {
                for (String string : ListInformationUtils.mechanism_info2) {
                    event.getToolTip().add(Component.literal((String)string));
                }
            }
        }
        if (item.equals(IUItem.upgrade_speed_creation.getItem()) && ListInformationUtils.mechanism_info1.size() > 0) {
            event.getToolTip().add(Component.literal((String)Localization.translate("using_kit")));
            if (!Keyboard.isKeyDown(340)) {
                event.getToolTip().add(new ArrayList<Component>(ListInformationUtils.mechanism_info1.values()).get(ListInformationUtils.index1));
            } else {
                for (Component component : ListInformationUtils.mechanism_info1.values()) {
                    event.getToolTip().add(component);
                }
            }
        }
        if (stack.getItem().equals(IUItem.analyzermodule.getItem())) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.analyzermodule")));
        }
        if (stack.getItem().equals(IUItem.quarrymodule.getItem())) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.quarrymodule")));
        }
        if (stack.getItem().equals(IUItem.expmodule.getItem())) {
            event.getToolTip().add(Component.literal((String)Localization.translate("iu.expierence_module.info")));
        }
        if (stack.getItem() instanceof ItemEntityModule) {
            int meta = ((ISubEnum)((ItemEntityModule)stack.getItem()).getElement()).getId();
            if (meta == 0) {
                event.getToolTip().add(Component.literal((String)Localization.translate("iu.entitymodule")));
            }
            if (meta == 1) {
                event.getToolTip().add(Component.literal((String)Localization.translate("iu.entitymodule1")));
            }
        }
        if (stack.getItem() instanceof ItemBaseModules) {
            EnumModule module = EnumModule.getFromID(((ISubEnum)((ItemBaseModules)stack.getItem()).getElement()).getId());
            if (module.type.equals((Object)EnumBaseType.PHASE)) {
                event.getToolTip().add(Component.literal((String)Localization.translate("iu.phasemodule")));
            }
            if (module.type.equals((Object)EnumBaseType.MOON_LINSE)) {
                event.getToolTip().add(Component.literal((String)Localization.translate("iu.moonlinse")));
            }
        }
        if (IUEventHandler.getUpgradeItem(stack) && UpgradeSystem.system.hasInMap(stack)) {
            List<UpgradeItemInform> lst = UpgradeSystem.system.getInformation(stack);
            int n = UpgradeSystem.system.getRemaining(stack);
            if (!lst.isEmpty()) {
                for (UpgradeItemInform upgradeItemInform : lst) {
                    event.getToolTip().add(Component.literal((String)upgradeItemInform.getName()));
                }
            }
            if (n != 0) {
                event.getToolTip().add(Component.literal((String)(Localization.translate("free_slot") + n + Localization.translate("free_slot1"))));
                if (Keyboard.isKeyDown(340)) {
                    event.getToolTip().add(Component.literal((String)Localization.translate("iu.can_upgrade_item")));
                    UpgradeItem upgradeItem = (UpgradeItem)stack.getItem();
                    List<String> list2 = UpgradeSystem.system.getAvailableUpgrade(upgradeItem, stack);
                    list2.forEach(s -> event.getToolTip().add(Component.literal((String)s)));
                }
            } else {
                event.getToolTip().add(Component.literal((String)Localization.translate("not_free_slot")));
            }
        }
        if (stack.getItem() instanceof IRoversItem && SpaceUpgradeSystem.system.hasInMap(stack)) {
            List<SpaceUpgradeItemInform> lst = SpaceUpgradeSystem.system.getInformation(stack);
            int n = SpaceUpgradeSystem.system.getRemaining(stack);
            if (!lst.isEmpty()) {
                for (SpaceUpgradeItemInform spaceUpgradeItemInform : lst) {
                    event.getToolTip().add(Component.literal((String)spaceUpgradeItemInform.getName()));
                }
            }
            if (n != 0) {
                event.getToolTip().add(Component.literal((String)(Localization.translate("free_slot") + n + Localization.translate("free_slot1"))));
                if (Keyboard.isKeyDown(340)) {
                    event.getToolTip().add(Component.literal((String)Localization.translate("iu.can_upgrade_item")));
                    IRoversItem iRoversItem = (IRoversItem)stack.getItem();
                    List<String> list3 = SpaceUpgradeSystem.system.getAvailableUpgrade(iRoversItem, stack);
                    list3.forEach(s -> event.getToolTip().add(Component.literal((String)s)));
                }
            } else {
                event.getToolTip().add(Component.literal((String)Localization.translate("not_free_slot")));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void addInfo(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        try {
            RecipeOutput output1;
            if (IUItem.machineRecipe == null) {
                IUItem.machineRecipe = Recipes.recipes.getRecipeStack("converter");
            }
            if (IUItem.fluidMatterRecipe == null) {
                IUItem.fluidMatterRecipe = Recipes.recipes.getRecipeStack("replicator");
            }
            if (this.tupleRecipe == null) {
                for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.machineRecipe) {
                    if (!entry.getKey().is(stack.getItem())) continue;
                    this.tupleRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                    if (!Keyboard.isKeyDown(340)) {
                        event.getToolTip().add(Component.nullToEmpty((String)Localization.translate("press.lshift")));
                    }
                    if (!Keyboard.isKeyDown(340)) break;
                    event.getToolTip().add(Component.nullToEmpty((String)Localization.translate("clonning")));
                    output1 = entry.getValue().output;
                    for (int i = 0; i < this.name.length; ++i) {
                        if (output1.metadata.getDouble("quantitysolid_" + i) == 0.0) continue;
                        event.getToolTip().add(Component.nullToEmpty((String)(String.valueOf(this.name[i]) + Localization.translate(this.mattertype[i]) + ": " + output1.metadata.getDouble("quantitysolid_" + i) + Localization.translate("matternumber"))));
                    }
                }
                if (this.tupleRecipe == null) {
                    this.tupleRecipe = new Tuple((Object)stack, (Object)this.EMPTY);
                }
            } else if (((ItemStack)this.tupleRecipe.getA()).is(stack.getItem())) {
                if (this.tupleRecipe.getB() != this.EMPTY && this.tupleRecipe.getB() != null) {
                    if (!Keyboard.isKeyDown(340)) {
                        event.getToolTip().add(Component.nullToEmpty((String)Localization.translate("press.lshift")));
                    }
                    if (Keyboard.isKeyDown(340)) {
                        event.getToolTip().add(Component.nullToEmpty((String)Localization.translate("clonning")));
                        RecipeOutput output12 = ((BaseMachineRecipe)this.tupleRecipe.getB()).output;
                        for (int i = 0; i < this.name.length; ++i) {
                            if (output12.metadata.getDouble("quantitysolid_" + i) == 0.0) continue;
                            event.getToolTip().add(Component.nullToEmpty((String)(String.valueOf(this.name[i]) + Localization.translate(this.mattertype[i]) + ": " + output12.metadata.getDouble("quantitysolid_" + i) + Localization.translate("matternumber"))));
                        }
                    }
                }
            } else {
                boolean find = false;
                for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.machineRecipe) {
                    if (!entry.getKey().is(stack.getItem())) continue;
                    this.tupleRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                    find = true;
                    if (!Keyboard.isKeyDown(340)) {
                        event.getToolTip().add(Component.nullToEmpty((String)Localization.translate("press.lshift")));
                    }
                    if (!Keyboard.isKeyDown(340)) break;
                    event.getToolTip().add(Component.nullToEmpty((String)Localization.translate("clonning")));
                    RecipeOutput output13 = entry.getValue().output;
                    for (int i = 0; i < this.name.length; ++i) {
                        if (output13.metadata.getDouble("quantitysolid_" + i) == 0.0) continue;
                        event.getToolTip().add(Component.nullToEmpty((String)(String.valueOf(this.name[i]) + Localization.translate(this.mattertype[i]) + ": " + output13.metadata.getDouble("quantitysolid_" + i) + Localization.translate("matternumber"))));
                    }
                }
                if (!find) {
                    this.tupleRecipe = new Tuple((Object)stack, (Object)this.EMPTY);
                }
            }
            if (this.tupleReplicatorRecipe == null) {
                for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.fluidMatterRecipe) {
                    if (!entry.getKey().is(stack.getItem())) continue;
                    if (!Keyboard.isKeyDown(340) && !event.getToolTip().contains(Component.nullToEmpty((String)Localization.translate("press.lshift")))) {
                        event.getToolTip().add(Component.nullToEmpty((String)Localization.translate("press.lshift")));
                    }
                    this.tupleReplicatorRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                    if (!Keyboard.isKeyDown(340)) break;
                    output1 = entry.getValue().output;
                    double matter = output1.metadata.getDouble("matter");
                    String usingMatter = ModUtils.getStringBukket(matter) + Localization.translate("iu.generic.text.bucketUnit");
                    event.getToolTip().add(Component.nullToEmpty((String)(Localization.translate("iu.replicator_using_matter") + String.valueOf(ChatFormatting.DARK_PURPLE) + usingMatter)));
                    break;
                }
                if (this.tupleReplicatorRecipe == null) {
                    this.tupleReplicatorRecipe = new Tuple((Object)stack, (Object)this.EMPTY);
                }
            } else if (this.tupleReplicatorRecipe != null) {
                if (this.tupleReplicatorRecipe.getA() != null && ((ItemStack)this.tupleReplicatorRecipe.getA()).is(stack.getItem())) {
                    if (this.tupleReplicatorRecipe.getB() != this.EMPTY) {
                        if (!Keyboard.isKeyDown(340) && !event.getToolTip().contains(Component.nullToEmpty((String)Localization.translate("press.lshift")))) {
                            event.getToolTip().add(Component.nullToEmpty((String)Localization.translate("press.lshift")));
                        }
                        if (Keyboard.isKeyDown(340)) {
                            RecipeOutput output14 = ((BaseMachineRecipe)this.tupleReplicatorRecipe.getB()).output;
                            double matter = output14.metadata.getDouble("matter");
                            String usingMatter = ModUtils.getStringBukket(matter) + Localization.translate("iu.generic.text.bucketUnit");
                            event.getToolTip().add(Component.nullToEmpty((String)(Localization.translate("iu.replicator_using_matter") + String.valueOf(ChatFormatting.DARK_PURPLE) + usingMatter)));
                        }
                    }
                } else {
                    this.tupleReplicatorRecipe = null;
                    for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.fluidMatterRecipe) {
                        if (!entry.getKey().is(stack.getItem())) continue;
                        if (!Keyboard.isKeyDown(340) && !event.getToolTip().contains(Component.nullToEmpty((String)Localization.translate("press.lshift")))) {
                            event.getToolTip().add(Component.nullToEmpty((String)Localization.translate("press.lshift")));
                        }
                        this.tupleReplicatorRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                        if (!Keyboard.isKeyDown(340)) break;
                        output1 = entry.getValue().output;
                        double matter = output1.metadata.getDouble("matter");
                        String usingMatter = ModUtils.getStringBukket(matter) + Localization.translate("iu.generic.text.bucketUnit");
                        event.getToolTip().add(Component.nullToEmpty((String)(Localization.translate("iu.replicator_using_matter") + String.valueOf(ChatFormatting.DARK_PURPLE) + usingMatter)));
                        break;
                    }
                    if (this.tupleReplicatorRecipe == null) {
                        this.tupleReplicatorRecipe = new Tuple((Object)stack, (Object)this.EMPTY);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ItemEntity checkAndTransform(ServerLevel world, ItemEntity entityItem) {
        LevelEntityGetter list1 = world.getEntities();
        ArrayList nearbyItems = Lists.newArrayList();
        list1.get(new AABB(entityItem.getX() - 1.0, entityItem.getY() - 1.0, entityItem.getZ() - 1.0, entityItem.getX() + 1.0, entityItem.getY() + 1.0, entityItem.getZ() + 1.0), p_151522_ -> {
            if (p_151522_ instanceof ItemEntity) {
                nearbyItems.add((ItemEntity)p_151522_);
            }
        });
        int redstoneNeeded = 4;
        int poloniumNeeded = 1;
        int electrumNeeded = 1;
        LinkedList<Object> redstoneItems = new LinkedList<Object>();
        LinkedList<Object> poloniumItems = new LinkedList<Object>();
        LinkedList<Object> electrumItems = new LinkedList<Object>();
        for (Object item : nearbyItems) {
            if (item.isRemoved()) continue;
            ItemStack stack = item.getItem();
            if (stack.getItem() == Items.REDSTONE && redstoneNeeded > 0) {
                redstoneItems.add(item);
                redstoneNeeded -= stack.getCount();
                continue;
            }
            if (stack.is((Item)IUItem.iudust.getStack(55)) && poloniumNeeded > 0) {
                poloniumItems.add(item);
                poloniumNeeded -= stack.getCount();
                continue;
            }
            if (!stack.is(electrumTag) || electrumNeeded <= 0) continue;
            electrumItems.add(item);
            electrumNeeded -= stack.getCount();
        }
        if (redstoneNeeded <= 0 && poloniumNeeded <= 0 && electrumNeeded <= 0) {
            int remainingRedstone = 4;
            for (Object item : redstoneItems) {
                ItemStack stack = item.getItem();
                if (stack.getCount() <= remainingRedstone) {
                    remainingRedstone -= stack.getCount();
                    item.setRemoved(Entity.RemovalReason.KILLED);
                    continue;
                }
                stack.shrink(remainingRedstone);
                break;
            }
            int remainingPolonium = 1;
            for (Object item : poloniumItems) {
                ItemStack itemStack = item.getItem();
                if (itemStack.getCount() <= remainingPolonium) {
                    remainingPolonium -= itemStack.getCount();
                    item.setRemoved(Entity.RemovalReason.KILLED);
                    continue;
                }
                itemStack.shrink(remainingPolonium);
                break;
            }
            int remainingElectrum = 1;
            for (ItemEntity itemEntity : electrumItems) {
                ItemStack stack = itemEntity.getItem();
                if (stack.getCount() <= remainingElectrum) {
                    remainingElectrum -= stack.getCount();
                    itemEntity.setRemoved(Entity.RemovalReason.KILLED);
                    continue;
                }
                stack.shrink(remainingElectrum);
                break;
            }
            ItemStack chargedRedstone = new ItemStack((ItemLike)IUItem.charged_redstone.getItem());
            return new ItemEntity((Level)world, entityItem.getX(), entityItem.getY(), entityItem.getZ(), chargedRedstone);
        }
        return null;
    }
}

