/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.api.item.energy.EnergyItem;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.Localization;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@OnlyIn(value=Dist.CLIENT)
public class ElectricItemTooltipHandler {
    public ElectricItemTooltipHandler() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void drawTooltips(ItemTooltipEvent event) {
        String tooltip;
        ItemStack stack = event.getItemStack();
        if (!stack.isEmpty() && stack.getItem() instanceof EnergyItem && !(tooltip = ElectricItem.manager.getToolTip(stack)).isEmpty()) {
            event.getToolTip().add(Component.literal((String)tooltip));
            if (KeyboardIU.isKeyDown(42)) {
                event.getToolTip().add(Component.literal((String)Localization.translate("iu.item.tooltip.PowerTier", ElectricItem.manager.getTier(stack))));
            }
        }
    }
}

