/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.entity;

import com.denfop.blockentity.bee.BlockEntityApiary;
import com.denfop.blockentity.crop.TileEntityCrop;
import com.denfop.entity.CollectCustomNectarGoal;
import com.denfop.entity.ReturnToHiveGoal;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class SmallBee
extends Bee {
    public com.denfop.api.bee.Bee bee;
    List<TileEntityCrop> crops;
    boolean can = true;
    private BlockPos hivePos;
    private boolean hasCustomNectar = false;

    public SmallBee(EntityType<? extends Bee> type, Level level) {
        super(type, level);
        this.setInvulnerable(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public void setCrops(List<TileEntityCrop> crops) {
        this.crops = crops;
    }

    public void setBee(com.denfop.api.bee.Bee bee) {
        this.bee = bee;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new CollectCustomNectarGoal(this));
        this.goalSelector.addGoal(6, (Goal)new ReturnToHiveGoal(this));
    }

    public boolean hasCustomNectar() {
        return this.hasCustomNectar;
    }

    public void setHasCustomNectar(boolean value) {
        this.hasCustomNectar = value;
    }

    public BlockPos getCustomHive() {
        return this.hivePos;
    }

    public void setCustomHive(BlockPos pos) {
        this.hivePos = pos;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("HasCustomNectar", this.hasCustomNectar);
        if (this.hivePos != null) {
            tag.put("HivePos", NbtUtils.writeBlockPos((BlockPos)this.hivePos));
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.hasCustomNectar = tag.getBoolean("HasCustomNectar");
        if (tag.contains("HivePos")) {
            this.hivePos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"HivePos").get();
        }
    }

    public void tick() {
        super.tick();
        if (this.can) {
            if (this.bee == null) {
                this.hivePos = new BlockPos((int)this.position().x, (int)this.position().y, (int)this.position().z);
                BlockEntity blockEntity = this.level().getBlockEntity(this.hivePos);
                if (blockEntity instanceof BlockEntityApiary) {
                    BlockEntityApiary apiary = (BlockEntityApiary)blockEntity;
                    this.bee = apiary.getQueen();
                }
            }
            this.can = false;
        }
    }

    public void pathfindRandomlyTowards(BlockPos targetPos) {
        Vec3 targetCenter = Vec3.atBottomCenterOf((Vec3i)targetPos);
        BlockPos currentPos = this.blockPosition();
        double distanceSq = this.position().distanceToSqr(targetCenter);
        if (distanceSq < 0.25) {
            return;
        }
        int verticalOffset = 0;
        int yDiff = (int)targetCenter.y - currentPos.getY();
        if (yDiff > 2) {
            verticalOffset = 4;
        } else if (yDiff < -2) {
            verticalOffset = -4;
        }
        int k = 6;
        int l = 8;
        int manhattan = currentPos.distManhattan((Vec3i)targetPos);
        if (manhattan < 15) {
            k = Math.max(manhattan / 2, 1);
            l = Math.max(manhattan / 2, 1);
        }
        Vec3 airPos = AirRandomPos.getPosTowards((PathfinderMob)this, (int)k, (int)l, (int)verticalOffset, (Vec3)targetCenter, (double)0.3141592741012573);
        if (manhattan < 4 || airPos == null) {
            this.navigation.setMaxVisitedNodesMultiplier(2.0f);
            this.navigation.moveTo(targetCenter.x, targetCenter.y, targetCenter.z, 1.0);
        } else {
            this.navigation.setMaxVisitedNodesMultiplier(2.0f);
            this.navigation.moveTo(airPos.x, airPos.y, airPos.z, 1.0);
        }
    }
}

