/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.effects;

import com.denfop.blockentity.base.BlockEntityAnvil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class BreakingItemParticle
extends TextureSheetParticle {
    private final float uo;
    private final float vo;

    BreakingItemParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, ItemStack pStack) {
        this(pLevel, pX, pY, pZ, pStack);
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += pXSpeed;
        this.yd += pYSpeed;
        this.zd += pZSpeed;
    }

    protected BreakingItemParticle(ClientLevel pLevel, double pX, double pY, double pZ, ItemStack pStack) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(pStack, (Level)pLevel, null, 0);
        this.setSprite(model.getOverrides().resolve(model, pStack, pLevel, null, 0).getParticleIcon(ModelData.EMPTY));
        this.gravity = 1.0f;
        this.quadSize /= 2.0f;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f * 16.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f * 16.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f * 16.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f * 16.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AnvilProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public AnvilProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            BlockEntity block = pLevel.getBlockEntity(new BlockPos((int)pX, (int)(pY - 1.0), (int)pZ));
            ItemStack stack = ItemStack.EMPTY;
            if (block instanceof BlockEntityAnvil) {
                stack = ((BlockEntityAnvil)block).inputSlotA.get(0);
            }
            return new BreakingItemParticle(pLevel, pX, pY, pZ, stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<ItemParticleOption> {
        public Particle createParticle(ItemParticleOption pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new BreakingItemParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pType.getItem());
        }
    }
}

