/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.dataregistry;

import com.denfop.dataregistry.DataItem;
import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DataSimpleItem<E extends Item, T extends ResourceLocation> {
    DeferredHolder<Item, E> registryObject;

    public DataSimpleItem(T resource, Supplier<E> supplier) {
        this(resource, supplier, "industrialupgrade", Register.ITEMS);
    }

    public DataSimpleItem(T resource, Supplier<E> supplier, String id, DeferredRegister<Item> ITEMS) {
        String namespace = resource.getNamespace().isEmpty() ? "" : resource.getNamespace() + "/";
        ResourceLocation key = ResourceLocation.tryBuild((String)id, (String)(namespace + resource.getPath()));
        DeferredHolder ret = DeferredHolder.create((ResourceKey)ITEMS.getRegistryKey(), (ResourceLocation)key);
        DataItem.objects.add((DeferredHolder<Item, Item>)ret);
        Map entries = ((DeferredRegisterAccessor)ITEMS).getEntries();
        if (entries.putIfAbsent(ret, supplier) != null) {
            throw new IllegalArgumentException("Duplicate registration " + String.valueOf(resource));
        }
        this.registryObject = ret;
    }

    public DeferredHolder<Item, E> getRegistryObject() {
        return this.registryObject;
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.registryObject.get());
    }

    public ItemStack getItem(int count) {
        return new ItemStack((ItemLike)this.registryObject.get(), count);
    }

    public E getItem() {
        return (E)((Item)this.registryObject.get());
    }
}

