/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.dataregistry;

import com.denfop.dataregistry.DataBlock;
import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;

public class DataSimpleBlock<E extends Block, F extends BlockItem> {
    private final DeferredHolder<Block, E> block;
    private DeferredHolder<Item, F> itemBlock;

    public DataSimpleBlock(Class<E> blockClass, Class<F> itemClass, String mainPath, String name) {
        try {
            Constructor<?> constructor = blockClass.getConstructors()[0];
            Supplier<Block> supplier = () -> {
                try {
                    return (Block)constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            ResourceLocation key = ResourceLocation.tryBuild((String)"industrialupgrade", (String)(mainPath + "/" + name.toLowerCase()));
            DeferredHolder ret = DeferredHolder.create((ResourceKey)Register.BLOCKS.getRegistryKey(), (ResourceLocation)key);
            Map entries = ((DeferredRegisterAccessor)Register.BLOCKS).getEntries();
            if (entries.putIfAbsent(ret, supplier) != null) {
                throw new IllegalArgumentException("Duplicate registration " + key.toString());
            }
            this.block = ret;
            this.registerBlockItem(ret, itemClass, mainPath, name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void registerBlockItem(DeferredHolder<Block, E> block, Class<F> itemClass, String mainPath, String name) {
        boolean indexMax = false;
        try {
            Constructor<?> constructor = itemClass.getConstructors()[0];
            Supplier<BlockItem> supplier = () -> {
                try {
                    return (BlockItem)constructor.newInstance(block.get());
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            ResourceLocation key = ResourceLocation.tryBuild((String)"industrialupgrade", (String)(mainPath + "/" + name.toLowerCase()));
            DeferredHolder ret = DeferredHolder.create((ResourceKey)Register.ITEMS.getRegistryKey(), (ResourceLocation)key);
            Map entries = ((DeferredRegisterAccessor)Register.ITEMS).getEntries();
            DataBlock.objects.add(ret);
            if (entries.putIfAbsent(ret, supplier) != null) {
                throw new IllegalArgumentException("Duplicate registration " + name);
            }
            this.itemBlock = ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DeferredHolder<Block, E> getBlock() {
        return this.block;
    }

    public BlockState getBlockState(int meta) {
        return ((Block)this.block.get()).defaultBlockState();
    }

    public BlockState getStateFromMeta(int meta) {
        return ((Block)this.block.get()).defaultBlockState();
    }

    public BlockState getDefaultState() {
        return ((Block)this.block.get()).defaultBlockState();
    }

    public F getItem() {
        return (F)((BlockItem)this.itemBlock.get());
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.itemBlock.get());
    }
}

