/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.dataregistry;

import com.denfop.blocks.ISubEnum;
import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class DataItem<T extends Enum<T>, E extends Item> {
    public static List<DeferredHolder<Item, Item>> objects = new ArrayList<DeferredHolder<Item, Item>>();
    List<DeferredHolder<Item, E>> registryObjectList;

    public DataItem(Class<T> typeClass, Class<E> itemClass) {
        HashMap<Enum, DeferredHolder> map = new HashMap<Enum, DeferredHolder>();
        Enum[] collections = (Enum[])typeClass.getEnumConstants();
        int indexMax = 0;
        for (Enum type : collections) {
            try {
                if (!Item.class.isAssignableFrom(itemClass)) {
                    throw new IllegalArgumentException("E must extend net.minecraft.world.item.Item");
                }
                Constructor<?> constructor = itemClass.getConstructors()[0];
                Supplier<Item> supplier = () -> {
                    try {
                        return (Item)constructor.newInstance(type);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                };
                ResourceLocation key = ResourceLocation.tryBuild((String)"industrialupgrade", (String)(((ISubEnum)((Object)type)).getMainPath() + "/" + ((ISubEnum)((Object)type)).getSerializedName() + ((ISubEnum)((Object)type)).getOtherPart()));
                if (indexMax < ((ISubEnum)((Object)type)).getId()) {
                    indexMax = ((ISubEnum)((Object)type)).getId();
                }
                if (!((ISubEnum)((Object)type)).register()) continue;
                DeferredHolder ret = DeferredHolder.create((ResourceKey)Register.ITEMS.getRegistryKey(), (ResourceLocation)key);
                objects.add((DeferredHolder<Item, Item>)ret);
                Map entries = ((DeferredRegisterAccessor)Register.ITEMS).getEntries();
                if (entries.putIfAbsent(ret, supplier) != null) {
                    throw new IllegalArgumentException("Duplicate registration " + String.valueOf(type));
                }
                map.put(type, ret);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.registryObjectList = new ArrayList<Object>(Collections.nCopies(indexMax + 1, null));
        for (Map.Entry entry : map.entrySet()) {
            this.registryObjectList.set(((ISubEnum)((Object)((Enum)entry.getKey()))).getId(), (DeferredHolder)entry.getValue());
        }
    }

    public E getStack(T meta) {
        return (E)((Item)this.registryObjectList.get(((ISubEnum)meta).getId()).get());
    }

    public E getStack(int meta) {
        return (E)((Item)this.registryObjectList.get(meta % this.registryObjectList.size()).get());
    }

    public ItemStack getItemStack(int meta) {
        return new ItemStack((ItemLike)this.registryObjectList.get(meta % this.registryObjectList.size()).get());
    }

    public ItemStack getItemStack(int meta, int col) {
        return new ItemStack((ItemLike)this.registryObjectList.get(meta % this.registryObjectList.size()).get(), col);
    }

    public E getItemFromMeta(int meta) {
        return (E)((Item)this.registryObjectList.get(meta % this.registryObjectList.size()).get());
    }

    public DeferredHolder<Item, E> getRegistryObject(int meta) {
        return this.registryObjectList.get(meta % this.registryObjectList.size());
    }

    public int getMeta(E item) {
        int i = 0;
        for (DeferredHolder<Item, E> registryObject : this.registryObjectList) {
            if (registryObject.get() == item) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getMeta(ItemStack itemStack) {
        int i = 0;
        Item item = itemStack.getItem();
        for (DeferredHolder<Item, E> registryObject : this.registryObjectList) {
            if (registryObject.get() == item) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public E getItem(T meta) {
        return (E)((Item)this.registryObjectList.get(((ISubEnum)meta).getId()).get());
    }
}

