/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datagen;

import com.denfop.componets.Fluids;
import com.denfop.datagen.ConfiguredFeaturesGen;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.material.Fluid;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> RUB_TREE_PLACED = ModPlacedFeatures.registerKey("rub_tree_placed");
    public static final ResourceKey<PlacedFeature> VEIN_PLACED = ModPlacedFeatures.registerKey("vein_placed");
    public static final ResourceKey<PlacedFeature> GEN_GAS_PLACED = ModPlacedFeatures.registerKey("gen_gas_placed");
    public static final ResourceKey<PlacedFeature> GEN_HIVE_PLACED = ModPlacedFeatures.registerKey("gen_hive_placed");
    public static final ResourceKey<PlacedFeature> VOLCANO_PLACED = ModPlacedFeatures.registerKey("volcano_placed");
    public static final ResourceKey<PlacedFeature> OIL_PLACED = ModPlacedFeatures.registerKey("oil_placed");
    public static final ResourceKey<PlacedFeature> CALCIUM_PLACED = ModPlacedFeatures.registerKey("calcium_placed");
    public static final ResourceKey<PlacedFeature> SALTPETER_PLACED = ModPlacedFeatures.registerKey("saltpeter_placed");
    public static final ResourceKey<PlacedFeature> PEAT_PLACED = ModPlacedFeatures.registerKey("peat_placed");
    public static final ResourceKey<PlacedFeature> GLOBAL_ORE_PLACED = ModPlacedFeatures.registerKey("global_ores");

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.tryBuild((String)"industrialupgrade", (String)name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.registerPlaced(context, RUB_TREE_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.RUB_TREE));
        ModPlacedFeatures.registerPlaced(context, GLOBAL_ORE_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.GLOBAL_ORE));
        ModPlacedFeatures.registerPlaced(context, VEIN_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.VEIN));
        ModPlacedFeatures.registerPlaced(context, GEN_GAS_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.GEN_GAS));
        ModPlacedFeatures.registerPlaced(context, GEN_HIVE_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.GEN_HIVE));
        ModPlacedFeatures.registerPlaced(context, VOLCANO_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.VOLCANO));
        ModPlacedFeatures.registerPlaced(context, OIL_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.OIL));
        ModPlacedFeatures.registerPlaced(context, CALCIUM_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.CALCIUM), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_TOP_SOLID, InSquarePlacement.spread(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()});
        ModPlacedFeatures.registerPlaced(context, SALTPETER_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.SALTPETER), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_TOP_SOLID, InSquarePlacement.spread(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()});
        ModPlacedFeatures.registerPlaced(context, PEAT_PLACED, configuredFeatures.getOrThrow(ConfiguredFeaturesGen.PEAT), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_TOP_SOLID, InSquarePlacement.spread(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()});
    }

    private static void registerPlaced(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuredFeature, PlacementModifier ... modifiers) {
        context.register(key, (Object)new PlacedFeature(configuredFeature, List.of(modifiers)));
    }

    private static void registerPlaced(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuredFeature) {
        context.register(key, (Object)new PlacedFeature(configuredFeature, List.of(InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome())));
    }
}

