/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datagen;

import com.denfop.datagen.IUChestLoot;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class IULootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceKey<LootTable>, LootTable.Builder>>>, LootContextParamSet>> industrialSubProviders = ImmutableList.of((Object)Pair.of(IUChestLoot::new, (Object)LootContextParamSets.CHEST));
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;
    public static ResourceKey<LootTable> VOLCANO_LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.tryBuild((String)"industrialupgrade", (String)"chests/volcano"));

    public IULootTableProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> p_323798_) {
        this.pathProvider = pOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loot_tables");
        this.registries = p_323798_;
    }

    private static ResourceLocation sequenceIdForLootTable(ResourceKey<LootTable> p_336172_) {
        return p_336172_.location();
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        HashMap map = Maps.newHashMap();
        MappedRegistry writableregistry = new MappedRegistry(Registries.LOOT_TABLE, Lifecycle.experimental());
        this.industrialSubProviders.forEach(arg_0 -> IULootTableProvider.lambda$run$1(map, (WritableRegistry)writableregistry, arg_0));
        writableregistry.freeze();
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        HolderGetter.Provider holdergetter$provider = new RegistryAccess.ImmutableRegistryAccess(List.of(writableregistry)).freeze().asGetterLookup();
        ValidationContext validationcontext = new ValidationContext((ProblemReporter)problemreporter$collector, LootContextParamSets.ALL_PARAMS, holdergetter$provider);
        Multimap multimap = problemreporter$collector.get();
        writableregistry.holders().forEach(p_335195_ -> ((LootTable)p_335195_.value()).validate(validationcontext.setParams(((LootTable)p_335195_.value()).getParamSet()).enterElement("{" + String.valueOf(p_335195_.key().location()) + "}", p_335195_.key())));
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(p_278900_ -> {
            ResourceLocation resourcelocation1 = (ResourceLocation)p_278900_.getKey();
            LootTable loottable = (LootTable)p_278900_.getValue();
            Path path = this.pathProvider.json(resourcelocation1);
            try {
                return DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)this.registries.get(), (Codec)LootTable.DIRECT_CODEC, (Object)loottable, (Path)path);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }).toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Loot Tables";
    }

    private static /* synthetic */ void lambda$run$1(Map map, WritableRegistry writableregistry, Pair p_124458_) {
        ((Consumer)((Supplier)p_124458_.getFirst()).get()).accept((p_176077_, p_176078_) -> {
            ResourceLocation resourcelocation = IULootTableProvider.sequenceIdForLootTable((ResourceKey<LootTable>)p_176077_);
            if (map.put(resourcelocation, p_176078_.setParamSet((LootContextParamSet)p_124458_.getSecond()).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(p_176077_));
            }
            p_176078_.setRandomSequence(resourcelocation);
            LootTable loottable = p_176078_.setParamSet((LootContextParamSet)p_124458_.getSecond()).build();
            writableregistry.register(p_176077_, (Object)loottable, RegistrationInfo.BUILT_IN);
        });
    }
}

