/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datacomponent;

import com.denfop.datacomponent.DataComponentsInit;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record WirelessConnection(ResourceLocation world, int tier, int x, int y, int z, boolean change) {
    public static final Codec<WirelessConnection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("world").forGetter(WirelessConnection::world), (App)Codec.INT.fieldOf("tier").forGetter(WirelessConnection::tier), (App)Codec.INT.fieldOf("x").forGetter(WirelessConnection::x), (App)Codec.INT.fieldOf("y").forGetter(WirelessConnection::y), (App)Codec.INT.fieldOf("z").forGetter(WirelessConnection::z), (App)Codec.BOOL.fieldOf("change").forGetter(WirelessConnection::change)).apply((Applicative)instance, WirelessConnection::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WirelessConnection> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        buf.writeResourceLocation(value.world());
        buf.writeInt(value.tier());
        buf.writeInt(value.x());
        buf.writeInt(value.y());
        buf.writeInt(value.z());
        buf.writeBoolean(value.change());
    }, buf -> new WirelessConnection(buf.readResourceLocation(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean()));
    public static WirelessConnection EMPTY = new WirelessConnection(Level.OVERWORLD.location(), 14, 0, 0, 0, false);

    public WirelessConnection updateChange(ItemStack stack, boolean change) {
        WirelessConnection wirelessConnection = new WirelessConnection(this.world, this.tier, this.x, this.y, this.z, change);
        stack.set(DataComponentsInit.WIRELESS, (Object)wirelessConnection);
        return wirelessConnection;
    }
}

